/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.email.Attachment;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.Contact;
import io.micronaut.email.MultipartBody;
import io.micronaut.email.StringBody;
import io.micronaut.email.validation.AnyRecipient;
import io.micronaut.email.validation.Recipients;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@AnyRecipient
@Introspected
public final class Email
implements Recipients {
    @NonNull
    @NotNull
    @Valid
    private final Contact from;
    @Nullable
    @Valid
    private final Contact replyTo;
    @Nullable
    @Valid
    private final Collection<Contact> to;
    @Nullable
    @Valid
    private final Collection<Contact> cc;
    @Nullable
    @Valid
    private final Collection<Contact> bcc;
    @NotBlank
    @NonNull
    private final String subject;
    @Nullable
    private final List<Attachment> attachments;
    @NonNull
    @NotNull
    private final Body body;

    private Email(@NonNull Contact from, @Nullable Contact replyTo, @Nullable List<Contact> to, @Nullable List<Contact> cc, @Nullable List<Contact> bcc, @NonNull String subject, @Nullable List<Attachment> attachments, @Nullable Body body) {
        this.from = from;
        this.replyTo = replyTo;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.attachments = attachments;
        this.body = body;
    }

    @NonNull
    public Contact getFrom() {
        return this.from;
    }

    @Nullable
    public Contact getReplyTo() {
        return this.replyTo;
    }

    @Override
    @Nullable
    public Collection<Contact> getTo() {
        return this.to;
    }

    @Override
    @Nullable
    public Collection<Contact> getCc() {
        return this.cc;
    }

    @Override
    @Nullable
    public Collection<Contact> getBcc() {
        return this.bcc;
    }

    @NonNull
    public String getSubject() {
        return this.subject;
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public Body getBody() {
        return this.body;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Contact from;
        @Nullable
        private List<Contact> to;
        @Nullable
        private String subject;
        @Nullable
        private Contact replyTo;
        @Nullable
        private List<Contact> cc;
        @Nullable
        private List<Contact> bcc;
        @Nullable
        private List<Attachment> attachments;
        @Nullable
        private Body body;

        @NonNull
        public Builder from(@NonNull String from) {
            this.from = new Contact(from);
            return this;
        }

        @NonNull
        public Builder from(@NonNull Contact from) {
            this.from = from;
            return this;
        }

        @NonNull
        public Builder replyTo(@NonNull String replyTo) {
            this.replyTo = new Contact(replyTo);
            return this;
        }

        @NonNull
        public Builder replyTo(@NonNull Contact replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        @NonNull
        public Builder to(@NonNull String to) {
            if (this.to == null) {
                this.to = new ArrayList<Contact>();
            }
            this.to.add(new Contact(to));
            return this;
        }

        @NonNull
        public Builder to(@NonNull Contact to) {
            this.addTo(to);
            return this;
        }

        private void addTo(@NonNull Contact to) {
            if (this.to == null) {
                this.to = new ArrayList<Contact>();
            }
            this.to.add(to);
        }

        @NonNull
        public Builder cc(@NonNull Contact cc) {
            this.addCc(cc);
            return this;
        }

        private void addCc(Contact cc) {
            if (this.cc == null) {
                this.cc = new ArrayList<Contact>();
            }
            this.cc.add(cc);
        }

        @NonNull
        public Builder cc(@NonNull String cc) {
            if (this.cc == null) {
                this.cc = new ArrayList<Contact>();
            }
            this.cc.add(new Contact(cc));
            return this;
        }

        @NonNull
        public Builder bcc(@NonNull Contact bcc) {
            this.addBcc(bcc);
            return this;
        }

        private void addBcc(@NonNull Contact bcc) {
            if (this.bcc == null) {
                this.bcc = new ArrayList<Contact>();
            }
            this.bcc.add(bcc);
        }

        @NonNull
        public Builder bcc(@NonNull String bcc) {
            if (this.bcc == null) {
                this.bcc = new ArrayList<Contact>();
            }
            this.bcc.add(new Contact(bcc));
            return this;
        }

        @NonNull
        public Builder subject(@NonNull String subject) {
            this.subject = subject;
            return this;
        }

        @NonNull
        public Builder attachment(@NonNull Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            this.attachments.add(attachment);
            return this;
        }

        @NonNull
        public Builder attachment(@NonNull Consumer<Attachment.Builder> attachment) {
            Attachment.Builder builder = Attachment.builder();
            attachment.accept(builder);
            return this.attachment(builder.build());
        }

        @NonNull
        public Builder body(@NonNull Body body) {
            this.body = body;
            return this;
        }

        @NonNull
        public Builder body(@NonNull String body, BodyType bodyType) {
            this.body = new StringBody(body, bodyType);
            return this;
        }

        @NonNull
        public Builder body(@NonNull String text) {
            this.body = new StringBody(text);
            return this;
        }

        @NonNull
        public Builder body(@NonNull String html, @NonNull String text) {
            this.body = new MultipartBody((Body)new StringBody(html, BodyType.HTML), (Body)new StringBody(text, BodyType.TEXT));
            return this;
        }

        @NonNull
        public Email build() {
            return new Email(this.from, this.replyTo, this.to, this.cc, this.bcc, this.subject, this.attachments, this.body);
        }

        @NonNull
        public Optional<Contact> getFrom() {
            return Optional.ofNullable(this.from);
        }

        @NonNull
        public Optional<Body> getBody() {
            return Optional.ofNullable(this.body);
        }

        @NonNull
        public Optional<List<Contact>> getTo() {
            return Optional.ofNullable(this.to);
        }

        @NonNull
        public Optional<String> getSubject() {
            return Optional.ofNullable(this.subject);
        }

        @NonNull
        public Optional<Contact> getReplyTo() {
            return Optional.ofNullable(this.replyTo);
        }

        @NonNull
        public Optional<List<Contact>> getCc() {
            return Optional.ofNullable(this.cc);
        }

        @NonNull
        public Optional<List<Contact>> getBcc() {
            return Optional.ofNullable(this.bcc);
        }

        @NonNull
        public Optional<List<Attachment>> getAttachments() {
            return Optional.ofNullable(this.attachments);
        }
    }
}

