/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Introspected
public class Attachment {
    @NonNull
    @NotBlank
    private final String filename;
    @NonNull
    @NotNull
    private final byte[] content;
    @NonNull
    @NotBlank
    private final String contentType;
    @Nullable
    private final String id;

    public Attachment(@NonNull String filename, @NonNull String contentType, @NonNull byte[] content, @Nullable String id) {
        this.filename = filename;
        this.content = content;
        this.contentType = contentType;
        this.id = id;
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    @NonNull
    public byte[] getContent() {
        return this.content;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public static class Builder {
        private String filename;
        private byte[] content;
        private String contentType;
        private String id;

        @NonNull
        public Builder filename(@NonNull String filename) {
            this.filename = filename;
            return this;
        }

        @NonNull
        public Builder contentType(@NonNull String contentType) {
            this.contentType = contentType;
            return this;
        }

        @NonNull
        public Builder content(@NonNull byte[] content) {
            this.content = content;
            return this;
        }

        @NonNull
        public Builder content(@NonNull File file) {
            try {
                if (file.length() == 0L) {
                    return this.content(new FileInputStream(file));
                }
                byte[] bytes = new byte[(int)file.length()];
                DataInputStream dis = new DataInputStream(new FileInputStream(file));
                dis.readFully(bytes);
                return this.content(bytes);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Could not read attachment file to bytes");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IOException while reading attachment file to bytes");
            }
        }

        @NonNull
        public Builder content(@NonNull InputStream inputStream) {
            try {
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[4];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byte[] result = buffer.toByteArray();
                buffer.close();
                return this.content(result);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Could not read attachment file to bytes");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IOException while reading attachment file to bytes");
            }
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Attachment build() {
            return new Attachment(Objects.requireNonNull(this.filename), Objects.requireNonNull(this.contentType), Objects.requireNonNull(this.content), this.id);
        }
    }
}

