/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.Email;
import io.micronaut.email.EmailDecorator;
import io.micronaut.email.EmailException;
import io.micronaut.email.EmailSender;
import io.micronaut.email.TransactionalEmailSender;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.function.Consumer;

@EachBean(value=TransactionalEmailSender.class)
public class DefaultEmailSender<I, O>
implements EmailSender<I, O> {
    private final TransactionalEmailSender<I, O> transactionalEmailSender;
    private final List<EmailDecorator> decorators;

    public DefaultEmailSender(TransactionalEmailSender<I, O> transactionalEmailSender, List<EmailDecorator> decorators) {
        this.transactionalEmailSender = transactionalEmailSender;
        this.decorators = decorators;
    }

    @Override
    @NonNull
    public O send(@NonNull @NotNull Email.Builder emailBuilder, @NonNull @NotNull Consumer<I> emailRequest) throws EmailException {
        for (EmailDecorator decorator : this.decorators) {
            decorator.decorate(emailBuilder);
        }
        return this.transactionalEmailSender.send(emailBuilder.build(), emailRequest);
    }

    @NonNull
    public String getName() {
        return this.transactionalEmailSender.getName();
    }
}

