/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.email.AsyncTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailException;
import io.micronaut.email.TransactionalEmailSender;
import jakarta.inject.Named;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractTransactionalEmailSender<I, O>
implements AsyncTransactionalEmailSender<I, O>,
TransactionalEmailSender<I, O> {
    private final Scheduler scheduler;

    protected AbstractTransactionalEmailSender(@Named(value="io") ExecutorService executorService) {
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)executorService);
    }

    @Override
    @NonNull
    @SingleResult
    public Publisher<O> sendAsync(@NonNull @NotNull Email email, @NonNull @NotNull Consumer<I> emailRequest) throws EmailException {
        return Mono.fromCallable(() -> this.send(email, emailRequest)).subscribeOn(this.scheduler);
    }
}

