/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Introspected
public class Contact {
    @NotNull
    @NotBlank
    @Email
    private final String email;
    @Nullable
    private final String name;

    public Contact(@NonNull String email) {
        this(email, null);
    }

    public Contact(@NonNull String email, @Nullable String name) {
        this.name = name;
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getNameAddress() {
        return StringUtils.isNotEmpty((CharSequence)this.getName()) ? String.format("%s <%s>", this.name, this.email) : "<" + this.email + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Contact contact = (Contact)o;
        if (!Objects.equals(this.email, contact.email)) {
            return false;
        }
        return Objects.equals(this.name, contact.name);
    }

    public int hashCode() {
        int result = this.email != null ? this.email.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

