/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.email.AsyncEmailSender;
import io.micronaut.email.AsyncTransactionalEmailSender;
import io.micronaut.email.Email;
import io.micronaut.email.EmailDecorator;
import io.micronaut.email.EmailException;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

@EachBean(value=AsyncTransactionalEmailSender.class)
public class DefaultAsyncEmailSender<I, O>
implements AsyncEmailSender<I, O> {
    private final AsyncTransactionalEmailSender<I, O> transactionalEmailSender;
    private final List<EmailDecorator> decorators;

    public DefaultAsyncEmailSender(AsyncTransactionalEmailSender<I, O> transactionalEmailSender, List<EmailDecorator> decorators) {
        this.transactionalEmailSender = transactionalEmailSender;
        this.decorators = decorators;
    }

    @Override
    @NonNull
    @SingleResult
    public Publisher<O> sendAsync(@NonNull @NotNull Email.Builder emailBuilder, @NonNull @NotNull Consumer<I> emailRequest) throws EmailException {
        for (EmailDecorator decorator : this.decorators) {
            decorator.decorate(emailBuilder);
        }
        return this.transactionalEmailSender.sendAsync(emailBuilder.build(), emailRequest);
    }

    @NonNull
    public String getName() {
        return this.transactionalEmailSender.getName();
    }
}

