/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.email;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.email.Body;
import io.micronaut.email.BodyType;
import io.micronaut.email.StringBody;
import java.util.Optional;

public class MultipartBody
implements Body {
    @NonNull
    private final Body html;
    @NonNull
    private final Body text;

    public MultipartBody(@NonNull String html, @NonNull String text) {
        this((Body)new StringBody(html, BodyType.HTML), (Body)new StringBody(text, BodyType.TEXT));
    }

    public MultipartBody(@NonNull Body html, @NonNull Body text) {
        if (!html.get(BodyType.HTML).isPresent()) {
            throw new IllegalArgumentException("Setting the HTML part in a multipart email must have the HTML body type");
        }
        if (!text.get(BodyType.TEXT).isPresent()) {
            throw new IllegalArgumentException("Setting the HTML part in a multipart email must have the HTML body type");
        }
        this.html = html;
        this.text = text;
    }

    public MultipartBody(@NonNull Body html, @NonNull String text) {
        this(html, (Body)new StringBody(text, BodyType.TEXT));
    }

    public MultipartBody(@NonNull String html, @NonNull Body text) {
        this((Body)new StringBody(html, BodyType.HTML), text);
    }

    @Override
    @NonNull
    public Optional<String> get(@NonNull BodyType bodyType) {
        switch (bodyType) {
            case TEXT: {
                return this.text.get(bodyType);
            }
        }
        return this.html.get(bodyType);
    }

    @NonNull
    public Body getHtml() {
        return this.html;
    }

    @NonNull
    public Body getText() {
        return this.text;
    }
}

