/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.flyway.AbstractFlywayMigration;
import io.micronaut.flyway.FlywayConfigurationProperties;
import io.micronaut.inject.qualifiers.Qualifiers;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlternativeMigrationRunner
extends AbstractFlywayMigration
implements BeanCreatedEventListener<FlywayConfigurationProperties> {
    static final Logger LOG = LoggerFactory.getLogger(Condition.class);

    public AlternativeMigrationRunner(ApplicationContext applicationContext, ApplicationEventPublisher eventPublisher) {
        super(applicationContext, eventPublisher);
    }

    public FlywayConfigurationProperties onCreated(BeanCreatedEvent<FlywayConfigurationProperties> event) {
        FlywayConfigurationProperties config = (FlywayConfigurationProperties)event.getBean();
        String name = config.getNameQualifier();
        if (config.isEnabled()) {
            if (config.hasAlternativeDatabaseConfiguration()) {
                DriverDataSource dataSource = new DriverDataSource(Thread.currentThread().getContextClassLoader(), null, config.getUrl(), config.getUser(), config.getPassword());
                this.run(config, (DataSource)dataSource);
            } else if (!this.applicationContext.containsBean(DataSource.class, Qualifiers.byName((String)name)) && LOG.isDebugEnabled()) {
                LOG.debug("* Flyway bean not created for identifier [" + name + "] because no data source was found with a named qualifier of the same name.");
            }
        }
        return config;
    }
}

