/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.flyway.FlywayConfigurationProperties;
import io.micronaut.flyway.event.MigrationFinishedEvent;
import io.micronaut.flyway.event.SchemaCleanedEvent;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.annotation.Async;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class AbstractFlywayMigration {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFlywayMigration.class);
    final ApplicationContext applicationContext;
    final ApplicationEventPublisher eventPublisher;

    AbstractFlywayMigration(ApplicationContext applicationContext, ApplicationEventPublisher eventPublisher) {
        this.applicationContext = applicationContext;
        this.eventPublisher = eventPublisher;
    }

    void run(FlywayConfigurationProperties config, DataSource dataSource) {
        if (config.isEnabled()) {
            this.forceRun(config, dataSource);
        }
    }

    void forceRun(FlywayConfigurationProperties config, DataSource dataSource) {
        FluentConfiguration fluentConfiguration = config.getFluentConfiguration();
        fluentConfiguration.dataSource(dataSource);
        Flyway flyway = fluentConfiguration.load();
        this.applicationContext.registerSingleton(Flyway.class, (Object)flyway, Qualifiers.byName((String)config.getNameQualifier()), false);
        if (config.isAsync()) {
            this.runAsync(config, flyway);
        } else {
            this.runFlyway(config, flyway);
        }
    }

    private void runFlyway(FlywayConfigurationProperties config, Flyway flyway) {
        if (config.isCleanSchema()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Cleaning schema for database with qualifier [{}]", (Object)config.getNameQualifier());
            }
            flyway.clean();
            this.eventPublisher.publishEvent((Object)new SchemaCleanedEvent(config));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Running migrations for database with qualifier [{}]", (Object)config.getNameQualifier());
        }
        flyway.migrate();
        this.eventPublisher.publishEvent((Object)new MigrationFinishedEvent(config));
    }

    @Async(value="io")
    void runAsync(FlywayConfigurationProperties config, Flyway flyway) {
        this.runFlyway(config, flyway);
    }
}

