/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway.graalvm;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import io.micronaut.flyway.graalvm.MicronautPathLocationScanner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@AutomaticFeature
final class FlywayFeature
implements Feature {
    private static final Logger LOG = LoggerFactory.getLogger(FlywayFeature.class);
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String JAR_APPLICATION_MIGRATIONS_PROTOCOL = "jar";
    private static final String FILE_APPLICATION_MIGRATIONS_PROTOCOL = "file";
    private static final String FLYWAY_LOCATIONS = "flyway.locations";
    private static final String DEFAULT_FLYWAY_LOCATIONS = "classpath:db/migration";

    FlywayFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        List<String> locations = Stream.of(System.getProperty(FLYWAY_LOCATIONS, DEFAULT_FLYWAY_LOCATIONS).split(",")).collect(Collectors.toList());
        try {
            List<String> migrations = this.discoverApplicationMigrations(locations);
            MicronautPathLocationScanner.setApplicationMigrationFiles(migrations);
        }
        catch (IOException | URISyntaxException e) {
            LOG.error("There was an error discovering the Flyway migrations: {}", (Object)e.getMessage());
        }
    }

    private List<String> discoverApplicationMigrations(List<String> locations) throws IOException, URISyntaxException {
        ArrayList<String> applicationMigrationResources = new ArrayList<String>();
        for (String location : locations) {
            if (location != null && location.startsWith("classpath:")) {
                location = location.substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1);
            }
            Enumeration<URL> migrations = Thread.currentThread().getContextClassLoader().getResources(location);
            while (migrations.hasMoreElements()) {
                Set<String> applicationMigrations;
                URL path = migrations.nextElement();
                LOG.debug("Adding application migrations in path '{}' using protocol '{}'", (Object)path.getPath(), (Object)path.getProtocol());
                if (JAR_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    try (FileSystem fileSystem = this.initFileSystem(path.toURI());){
                        applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                    }
                } else if (FILE_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
                    applicationMigrations = this.getApplicationMigrationsFromPath(location, path);
                } else {
                    LOG.warn("Unsupported URL protocol '{}' for path '{}'. Migration files will not be discovered.", (Object)path.getProtocol(), (Object)path.getPath());
                    applicationMigrations = null;
                }
                if (applicationMigrations == null) continue;
                applicationMigrationResources.addAll(applicationMigrations);
            }
        }
        return applicationMigrationResources;
    }

    private Set<String> getApplicationMigrationsFromPath(String location, URL path) throws IOException, URISyntaxException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(path.toURI()), new FileVisitOption[0]);){
            Set<String> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> Paths.get(location, it.getFileName().toString()).toString()).map(it -> it.replace('\\', '/')).peek(it -> LOG.trace("Discovered path: {}", it)).collect(Collectors.toSet());
            return set;
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        return FileSystems.newFileSystem(uri, env);
    }
}

