/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.configuration.FluentConfiguration;

@Context
@EachProperty(value="flyway.datasources")
public class FlywayConfigurationProperties
implements Toggleable {
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ASYNC = false;
    public static final boolean DEFAULT_CLEAN_SCHEMA = false;
    @ConfigurationBuilder(prefixes={""}, excludes={"jdbcProperties", "configuration", "dryRunOutput", "ignoreMigrationPatterns", "locations", "encoding", "target", "javaMigrations", "dataSource", "baselineVersion", "callbacks", "resolvers", "resourceProvider", "javaMigrationClassProvider", "allEnvironments", "environmentProvisionMode"})
    FluentConfiguration fluentConfiguration = new FluentConfiguration();
    private final String nameQualifier;
    private boolean enabled = true;
    private boolean async = false;
    private boolean cleanSchema = false;
    private String url;
    private String user;
    private String password;
    private Map<String, String> properties = new HashMap<String, String>();

    public FlywayConfigurationProperties(@Parameter String name) {
        this.nameQualifier = name;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isCleanSchema() {
        return this.cleanSchema;
    }

    public void setCleanSchema(boolean cleanSchema) {
        this.cleanSchema = cleanSchema;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUsername(String username) {
        this.user = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasAlternativeDatabaseConfiguration() {
        return StringUtils.hasText((CharSequence)this.getUrl());
    }

    public FluentConfiguration getFluentConfiguration() {
        return this.fluentConfiguration;
    }

    public void setProperties(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.CAMEL_CASE) Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setDryRunOutput(String dryRunOutputFileName) {
        this.fluentConfiguration.dryRunOutput(dryRunOutputFileName);
    }

    public void setIgnoreMigrationPatterns(String ... ignoreMigrationPatterns) {
        this.fluentConfiguration.ignoreMigrationPatterns(ignoreMigrationPatterns);
    }

    public void setLocations(String ... locations) {
        this.fluentConfiguration.locations(locations);
    }

    public void setEncoding(String encoding) {
        this.fluentConfiguration.encoding(encoding);
    }

    public void setTarget(String target) {
        this.fluentConfiguration.target(target);
    }

    public void setBaselineVersion(String baselineVersion) {
        this.fluentConfiguration.baselineVersion(baselineVersion);
    }
}

