/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.util.StringUtils;
import org.graalvm.nativeimage.ImageSingletons;

@Internal
final class StaticResourceProvider
implements ResourceProvider {
    private static final String FLYWAY_LOCATIONS = "flyway.locations";
    private static final String DEFAULT_FLYWAY_LOCATIONS = "classpath:db/migration";
    private static final String CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL = "classpath";
    private static final String JAR_APPLICATION_MIGRATIONS_PROTOCOL = "jar";
    private static final String FILE_APPLICATION_MIGRATIONS_PROTOCOL = "file";
    private final List<StaticLoadableResource> resources;

    private StaticResourceProvider(List<StaticLoadableResource> resources) {
        this.resources = resources;
    }

    static StaticResourceProvider get() {
        return StaticResourceProvider.findStaticResourceProvider();
    }

    static void install(ClassLoader classLoader) {
        if (StaticResourceProvider.hasImageSingletons()) {
            StaticResourceProvider staticResourceProvider = StaticResourceProvider.create(classLoader);
            ImageSingletons.add(StaticResourceProvider.class, (Object)staticResourceProvider);
        }
    }

    static StaticResourceProvider create(ClassLoader classLoader) {
        List<String> locations = Stream.of(System.getProperty(FLYWAY_LOCATIONS, DEFAULT_FLYWAY_LOCATIONS).split(",")).toList();
        try {
            List<StaticLoadableResource> resources = StaticResourceProvider.discoverApplicationMigrations(locations, classLoader);
            return new StaticResourceProvider(resources);
        }
        catch (IOException | URISyntaxException e) {
            throw new ConfigurationException("Error loading Flyway migrations: " + e.getMessage(), (Throwable)e);
        }
    }

    public LoadableResource getResource(String name) {
        return this.resources.stream().filter(resource -> resource.getAbsolutePath().equals(name)).findFirst().orElse(null);
    }

    public Collection<LoadableResource> getResources(String prefix, String[] suffixes) {
        return this.resources.stream().filter(resource -> StringUtils.startsAndEndsWith((String)resource.getFilename(), (String)prefix, (String[])suffixes)).map(LoadableResource.class::cast).toList();
    }

    @Nullable
    private static StaticResourceProvider findStaticResourceProvider() {
        return StaticResourceProvider.hasImageSingletons() && ImageSingletons.contains(StaticResourceProvider.class) ? (StaticResourceProvider)ImageSingletons.lookup(StaticResourceProvider.class) : null;
    }

    private static boolean hasImageSingletons() {
        try {
            return ImageSingletons.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static List<StaticLoadableResource> discoverApplicationMigrations(List<String> locations, ClassLoader classLoader) throws IOException, URISyntaxException {
        ArrayList<StaticLoadableResource> applicationMigrationResources = new ArrayList<StaticLoadableResource>();
        for (String location : locations) {
            if (location != null && location.startsWith("classpath:")) {
                location = location.substring(CLASSPATH_APPLICATION_MIGRATIONS_PROTOCOL.length() + 1);
            }
            Enumeration<URL> migrations = classLoader.getResources(location);
            while (migrations.hasMoreElements()) {
                URL path = migrations.nextElement();
                StaticResourceProvider.applicationMigrations(path, location).ifPresent(applicationMigrationResources::addAll);
            }
        }
        return applicationMigrationResources;
    }

    private static Optional<Set<StaticLoadableResource>> applicationMigrations(@NonNull URL path, String location) throws URISyntaxException, IOException {
        if (JAR_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
            try (FileSystem fileSystem = StaticResourceProvider.initFileSystem(path.toURI());){
                Optional<Set<StaticLoadableResource>> optional = Optional.of(StaticResourceProvider.getApplicationMigrationsFromPath(location, path));
                return optional;
            }
        }
        if (FILE_APPLICATION_MIGRATIONS_PROTOCOL.equals(path.getProtocol())) {
            return Optional.of(StaticResourceProvider.getApplicationMigrationsFromPath(location, path));
        }
        return Optional.empty();
    }

    private static Set<StaticLoadableResource> getApplicationMigrationsFromPath(String location, URL path) throws IOException, URISyntaxException {
        try (Stream<Path> pathStream = Files.walk(Paths.get(path.toURI()), new FileVisitOption[0]);){
            Set<StaticLoadableResource> set = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(it -> new StaticLoadableResource(location, (Path)it)).collect(Collectors.toSet());
            return set;
        }
    }

    private static FileSystem initFileSystem(URI uri) throws IOException {
        return FileSystems.newFileSystem(uri, Collections.singletonMap("create", "true"));
    }

    static final class StaticLoadableResource
    extends LoadableResource {
        private final String location;
        private final String absolutePath;
        private final String fileName;
        private final byte[] bytes;

        StaticLoadableResource(String location, Path it) {
            byte[] readBytes;
            this.location = location;
            this.absolutePath = it.toAbsolutePath().toString();
            this.fileName = it.getFileName().toString();
            try {
                readBytes = Files.readAllBytes(it);
            }
            catch (IOException e) {
                readBytes = new byte[]{};
            }
            this.bytes = readBytes;
        }

        public Reader read() {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.bytes), StandardCharsets.UTF_8);
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public String getAbsolutePathOnDisk() {
            return this.getAbsolutePath();
        }

        public String getFilename() {
            return this.fileName;
        }

        public String getRelativePath() {
            return this.location + File.pathSeparator + this.fileName;
        }

        public String toString() {
            return "StaticLoadableResource{location='" + this.location + "', absolutePath='" + this.absolutePath + "', fileName='" + this.fileName + "'}";
        }
    }
}

