/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.flyway;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.flyway.FlywayConfigurationCustomizer;
import io.micronaut.inject.qualifiers.Qualifiers;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.resolver.MigrationResolver;

public class DefaultFlywayConfigurationCustomizer
implements FlywayConfigurationCustomizer {
    private final ApplicationContext applicationContext;
    private final String name;

    DefaultFlywayConfigurationCustomizer(ApplicationContext applicationContext, String name) {
        this.applicationContext = applicationContext;
        this.name = name;
    }

    @Override
    public void customizeFluentConfiguration(FluentConfiguration fluentConfiguration) {
        this.applicationContext.findBean(JavaMigration[].class, Qualifiers.byName((String)this.name)).ifPresent(arg_0 -> ((FluentConfiguration)fluentConfiguration).javaMigrations(arg_0));
        this.applicationContext.findBean(Callback[].class, Qualifiers.byName((String)this.name)).ifPresent(arg_0 -> ((FluentConfiguration)fluentConfiguration).callbacks(arg_0));
        this.applicationContext.findBean(MigrationResolver[].class, Qualifiers.byName((String)this.name)).ifPresent(arg_0 -> ((FluentConfiguration)fluentConfiguration).resolvers(arg_0));
        this.applicationContext.findBean(ResourceProvider.class, Qualifiers.byName((String)this.name)).ifPresent(arg_0 -> ((FluentConfiguration)fluentConfiguration).resourceProvider(arg_0));
        this.applicationContext.findBean(Argument.of(ClassProvider.class, (Argument[])new Argument[]{Argument.of(JavaMigration.class)}), Qualifiers.byName((String)this.name)).ifPresent(arg_0 -> ((FluentConfiguration)fluentConfiguration).javaMigrationClassProvider(arg_0));
    }

    @NonNull
    public String getName() {
        return this.name;
    }
}

