/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp;

import com.google.api.gax.rpc.HeaderProvider;
import java.util.Collections;
import java.util.Map;

public class UserAgentHeaderProvider
implements HeaderProvider {
    private String userAgent;
    private final Map<String, String> headers;

    public UserAgentHeaderProvider(String component) {
        this.userAgent = this.computeUserAgent(component);
        this.headers = Collections.singletonMap("User-Agent", this.userAgent);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    private String computeUserAgent(String component) {
        String library = "micronaut-gcp-" + component;
        String version = this.getClass().getPackage().getImplementationVersion();
        return "Micronaut/" + version + " " + library + "/" + version;
    }
}

