/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.gcp;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.discovery.cloud.AbstractComputeInstanceMetadata;
import io.micronaut.http.HttpMethod;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
final class GoogleComputeInstanceMetadataResolverUtils {
    private GoogleComputeInstanceMetadataResolverUtils() {
    }

    static Optional<String> stringValue(JsonNode json, String key) {
        return Optional.ofNullable(json.get(key)).map(JsonNode::coerceStringValue);
    }

    static JsonNode readMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, JsonMapper jsonMapper, Map<String, String> requestProperties) throws IOException {
        try (InputStream in = GoogleComputeInstanceMetadataResolverUtils.openMetadataUrl(url, connectionTimeoutMs, readTimeoutMs, requestProperties);){
            JsonNode jsonNode = (JsonNode)jsonMapper.readValue(in, Argument.of(JsonNode.class));
            return jsonNode;
        }
    }

    private static InputStream openMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, Map<String, String> requestProperties) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            urlConnection.connect();
            return urlConnection.getInputStream();
        }
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        requestProperties.forEach(uc::setRequestProperty);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod(HttpMethod.GET.name());
        uc.setDoOutput(true);
        return uc.getInputStream();
    }

    static void populateMetadata(@NonNull AbstractComputeInstanceMetadata instanceMetadata, @NonNull Map<?, ?> metadata) {
        Map<String, String> stringMetadata = metadata.entrySet().stream().filter(e -> e.getValue() instanceof String).map(e -> new AbstractMap.SimpleEntry<String, String>(e.getKey().toString(), e.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        instanceMetadata.setMetadata(stringMetadata);
    }
}

