/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.credentials;

import com.google.auth.RequestMetadataCallback;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.MutableArgumentValue;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthenticationLoggingInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationLoggingInterceptor.class);
    private static final String LOGGED_AUTHENTICATION_METHOD = "getRequestMetadata";

    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (!context.getExecutableMethod().getMethodName().equals(LOGGED_AUTHENTICATION_METHOD)) {
            return context.proceed();
        }
        Map params = context.getParameters();
        params.entrySet().stream().filter(entry -> ((MutableArgumentValue)entry.getValue()).getType().equals(RequestMetadataCallback.class)).findFirst().ifPresent(entry -> {
            MutableArgumentValue argValue = (MutableArgumentValue)entry.getValue();
            RequestMetadataCallback callback = (RequestMetadataCallback)argValue.getValue();
            argValue.setValue((Object)new LoggingRequestMetadataCallback(callback));
        });
        return context.proceed();
    }

    private static final class LoggingRequestMetadataCallback
    implements RequestMetadataCallback {
        private final RequestMetadataCallback callback;

        private LoggingRequestMetadataCallback(RequestMetadataCallback callback) {
            this.callback = callback;
        }

        public void onSuccess(Map<String, List<String>> metadata) {
            this.callback.onSuccess(metadata);
        }

        public void onFailure(Throwable ex) {
            if (ex instanceof IOException) {
                LOG.warn("A failure occurred while attempting to build credential metadata for a GCP API request. The GCP libraries treat this as a retryable error, but misconfigured credentials can keep it from ever succeeding.", ex);
            }
            this.callback.onFailure(ex);
        }
    }
}

