/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.condition;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.gcp.GoogleCloudConfiguration;

public class RequiresProjectIdCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        GoogleCloudConfiguration cloudConfiguration = (GoogleCloudConfiguration)context.getBeanContext().getBean(GoogleCloudConfiguration.class);
        if (!cloudConfiguration.hasProjectId()) {
            context.fail("No Google Cloud Project ID found. See ServiceOptions.getDefaultProjectId() for description on how to configure the service ID");
            return false;
        }
        return true;
    }
}

