/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.credentials;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.StreamingContent;
import com.google.auth.http.HttpTransportFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(classes={HttpClient.class}), @Requires(property="gcp.credentials.use-http-client", value="true", defaultValue="true")})
public class DefaultOAuth2HttpTransportFactory
implements HttpTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOAuth2HttpTransportFactory.class);
    private final HttpClientHttpTransport transport;

    public DefaultOAuth2HttpTransportFactory(BeanContext beanContext, HttpClientConfiguration defaultClientConfiguration) {
        HttpClient httpClient = (HttpClient)beanContext.createBean(HttpClient.class, new Object[]{LoadBalancer.empty(), defaultClientConfiguration});
        this.transport = new HttpClientHttpTransport(httpClient);
    }

    public HttpTransport create() {
        return this.transport;
    }

    private static final class HttpClientHttpTransport
    extends HttpTransport {
        private final HttpClient httpClient;

        public HttpClientHttpTransport(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        protected LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
            return new MutableBlockingLowLevelHttpRequest(this.httpClient, method, url);
        }
    }

    private static final class BlockingLowLevelHttpResponse
    extends LowLevelHttpResponse {
        private final HttpResponse<?> bufferedResponse;
        private final List<String> indexedHeaderNames = new ArrayList<String>();
        private final List<String> indexedHeaderValues = new ArrayList<String>();

        private BlockingLowLevelHttpResponse(HttpResponse<?> response) {
            this.bufferedResponse = response;
            if (this.bufferedResponse != null) {
                this.bufferedResponse.getHeaders().forEach((name, values) -> {
                    this.indexedHeaderNames.add((String)name);
                    this.indexedHeaderValues.add(String.join((CharSequence)",", values));
                });
            }
        }

        public InputStream getContent() {
            ByteBuffer body = this.bufferedResponse.getBody(ByteBuffer.class).orElse(null);
            return body != null ? body.toInputStream() : null;
        }

        public String getContentEncoding() {
            return (String)this.bufferedResponse.getHeaders().get((CharSequence)"Content-Encoding");
        }

        public long getContentLength() {
            return this.bufferedResponse.getContentLength();
        }

        public String getContentType() {
            return this.bufferedResponse.getContentType().map(MediaType::toString).orElse(null);
        }

        public String getStatusLine() {
            return this.bufferedResponse.getStatus().getReason();
        }

        public int getStatusCode() {
            return this.bufferedResponse.code();
        }

        public String getReasonPhrase() {
            return this.bufferedResponse.reason();
        }

        public int getHeaderCount() {
            return this.bufferedResponse.getHeaders().asMap().size();
        }

        public String getHeaderName(int index) {
            return this.indexedHeaderNames.get(index);
        }

        public String getHeaderValue(int index) {
            return this.indexedHeaderValues.get(index);
        }
    }

    public static final class MutableBlockingLowLevelHttpRequest
    extends LowLevelHttpRequest {
        private final BlockingHttpClient httpClient;
        private final MutableHttpRequest<StreamingContent> request;

        private MutableBlockingLowLevelHttpRequest(HttpClient httpClient, String method, String url) {
            this.httpClient = httpClient.toBlocking();
            this.request = HttpRequest.create((HttpMethod)HttpMethod.valueOf((String)method), (String)url);
        }

        public void addHeader(String name, String value) throws IOException {
            this.request.header((CharSequence)name, (CharSequence)value);
        }

        public LowLevelHttpResponse execute() throws IOException {
            if (this.getStreamingContent() == null) {
                this.writeContentHeaders((MutableHeaders)this.request.getHeaders());
            }
            this.request.body((Object)this);
            try {
                return new BlockingLowLevelHttpResponse(this.httpClient.exchange(this.request));
            }
            catch (HttpClientResponseException ce) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("A {} {} response was received from {} while attempting to retrieve an access token for a GCP API request. The GCP libraries treat this as a retryable error, but misconfigured credentials can keep it from ever succeeding.", new Object[]{ce.getStatus().getCode(), ce.getStatus().getReason(), this.request.getUri()});
                }
                return new BlockingLowLevelHttpResponse(ce.getResponse());
            }
            catch (Throwable ex) {
                throw new IOException(ex);
            }
        }

        void writeContentHeaders(MutableHeaders headers) {
            if (this.getContentEncoding() != null) {
                headers.add((CharSequence)"Content-Encoding", (CharSequence)this.getContentEncoding());
            }
            if (this.getContentType() != null) {
                headers.add((CharSequence)"Content-Type", (CharSequence)this.getContentType());
            }
            if (this.getContentLength() > -1L) {
                headers.add((CharSequence)"Content-Length", (CharSequence)String.valueOf(this.getContentLength()));
            }
        }
    }
}

