/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.credentials;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.Toggleable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@ConfigurationProperties(value="gcp.credentials")
@Context
@BootstrapContextCompatible
public class GoogleCredentialsConfiguration
implements Toggleable {
    public static final boolean DEFAULT_ENABLED = true;
    public static final List<URI> DEFAULT_SCOPES = Collections.emptyList();
    public static final boolean DEFAULT_USE_HTTP_CLIENT = true;
    public static final String PREFIX = "gcp.credentials";
    private boolean enabled = true;
    private List<URI> scopes = DEFAULT_SCOPES;
    private boolean useHttpClient = true;
    private String location;
    private String encodedKey;

    @NonNull
    public List<URI> getScopes() {
        return this.scopes;
    }

    public void setScopes(@Nullable List<URI> scopes) {
        this.scopes = scopes == null ? Collections.emptyList() : scopes;
    }

    @NonNull
    public Optional<String> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    @NonNull
    public Optional<String> getEncodedKey() {
        return Optional.ofNullable(this.encodedKey);
    }

    public void setEncodedKey(@Nullable String encodedKey) {
        this.encodedKey = encodedKey;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseHttpClient() {
        return this.useHttpClient;
    }

    public void setUseHttpClient(boolean useHttpClient) {
        this.useHttpClient = useHttpClient;
    }
}

