/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.gcp;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.gcp.GoogleComputeInstanceMetadata;
import io.micronaut.discovery.cloud.gcp.GoogleComputeInstanceMetadataResolverUtils;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataConfiguration;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataKeys;
import io.micronaut.discovery.cloud.gcp.GoogleComputeNetworkInterface;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(env={"gcp"}), @Requires(property="micronaut.application.gcp.metadata.enabled", value="true", defaultValue="true")})
@Primary
public class GoogleComputeInstanceMetadataResolver
implements ComputeInstanceMetadataResolver {
    public static final String HEADER_METADATA_FLAVOR = "Metadata-Flavor";
    private static final Logger LOG = LoggerFactory.getLogger(GoogleComputeInstanceMetadataResolver.class);
    private final JsonMapper jsonMapper;
    private final GoogleComputeMetadataConfiguration configuration;
    private GoogleComputeInstanceMetadata cachedMetadata;

    @Inject
    public GoogleComputeInstanceMetadataResolver(JsonMapper jsonMapper, GoogleComputeMetadataConfiguration configuration) {
        this.jsonMapper = jsonMapper;
        this.configuration = configuration;
    }

    public GoogleComputeInstanceMetadataResolver() {
        this.jsonMapper = JsonMapper.createDefault();
        this.configuration = new GoogleComputeMetadataConfiguration();
    }

    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        GoogleComputeInstanceMetadata instanceMetadata;
        block23: {
            if (!this.configuration.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolving of Google Compute Instance metadata is disabled");
                }
                return Optional.empty();
            }
            if (this.cachedMetadata != null) {
                this.cachedMetadata.setCached(true);
                return Optional.of(this.cachedMetadata);
            }
            instanceMetadata = null;
            try {
                JsonNode projectResultJson;
                HashMap<String, String> requestProperties;
                int readTimeoutMs;
                int connectionTimeoutMs;
                block22: {
                    connectionTimeoutMs = (int)this.configuration.getConnectTimeout().toMillis();
                    readTimeoutMs = (int)this.configuration.getReadTimeout().toMillis();
                    requestProperties = new HashMap<String, String>();
                    requestProperties.put(HEADER_METADATA_FLAVOR, "Google");
                    projectResultJson = null;
                    try {
                        projectResultJson = GoogleComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(this.configuration.getProjectMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs, this.jsonMapper, requestProperties);
                    }
                    catch (MalformedURLException me) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Google compute project metadataUrl value is invalid!: " + this.configuration.getProjectMetadataUrl(), (Throwable)me);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No project metadata found at: " + this.configuration.getProjectMetadataUrl() + "?recursive=true", (Throwable)fnfe);
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug("Error connecting to" + this.configuration.getProjectMetadataUrl() + "?recursive=true reading project metadata. Not a Google environment?", (Throwable)ioe);
                    }
                }
                JsonNode instanceMetadataJson = GoogleComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(this.configuration.getMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs, this.jsonMapper, requestProperties);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read compute instance metadata from URL [{}]. Resulting JSON: {}", (Object)this.configuration.getMetadataUrl(), (Object)instanceMetadataJson);
                }
                if (environment.getActiveNames().contains("gae")) {
                    instanceMetadata = new GoogleComputeInstanceMetadata();
                    instanceMetadata.setInstanceId(System.getenv("GAE_INSTANCE"));
                    instanceMetadata.setAccount(System.getenv("GOOGLE_CLOUD_PROJECT"));
                }
                if (instanceMetadataJson != null) {
                    if (instanceMetadata == null) {
                        instanceMetadata = new GoogleComputeInstanceMetadata();
                    }
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.ID.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setInstanceId(arg_0));
                    if (projectResultJson != null) {
                        GoogleComputeInstanceMetadataResolverUtils.stringValue(projectResultJson, GoogleComputeMetadataKeys.PROJECT_ID.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setAccount(arg_0));
                    } else {
                        GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.PROJECT_ID.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setAccount(arg_0));
                    }
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.ZONE.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setAvailabilityZone(arg_0));
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.MACHINE_TYPE.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setMachineType(arg_0));
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.DESCRIPTION.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setDescription(arg_0));
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.IMAGE.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setImageId(arg_0));
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.HOSTNAME.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setLocalHostname(arg_0));
                    GoogleComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.NAME.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)instanceMetadata).setName(arg_0));
                    JsonNode networkInterfaces = instanceMetadataJson.get(GoogleComputeMetadataKeys.NETWORK_INTERFACES.getName());
                    if (networkInterfaces != null) {
                        ArrayList interfaces = new ArrayList();
                        AtomicInteger networkCounter = new AtomicInteger(0);
                        GoogleComputeInstanceMetadata finalInstanceMetadata = instanceMetadata;
                        networkInterfaces.values().forEach(jsonNode -> {
                            GoogleComputeNetworkInterface networkInterface = new GoogleComputeNetworkInterface();
                            networkInterface.setId(String.valueOf(networkCounter.getAndIncrement()));
                            if (jsonNode.get(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName()) != null) {
                                JsonNode accessConfigs = jsonNode.get(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName());
                                GoogleComputeInstanceMetadataResolverUtils.stringValue(accessConfigs.get(0), "externalIp").ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)finalInstanceMetadata).setPublicIpV4(arg_0));
                            }
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.IP.getName()).ifPresent(arg_0 -> ((GoogleComputeInstanceMetadata)finalInstanceMetadata).setPrivateIpV4(arg_0));
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.IP.getName()).ifPresent(networkInterface::setIpv4);
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.MAC.getName()).ifPresent(networkInterface::setMac);
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.NETWORK.getName()).ifPresent(networkInterface::setNetwork);
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.NETMASK.getName()).ifPresent(networkInterface::setNetmask);
                            GoogleComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.GATEWAY.getName()).ifPresent(networkInterface::setGateway);
                            interfaces.add(networkInterface);
                        });
                        instanceMetadata.setInterfaces(interfaces);
                    }
                    Map metadata = (Map)this.jsonMapper.readValueFromTree(instanceMetadataJson, Map.class);
                    GoogleComputeInstanceMetadataResolverUtils.populateMetadata(instanceMetadata, metadata);
                    this.cachedMetadata = instanceMetadata;
                    return Optional.of(instanceMetadata);
                }
            }
            catch (MalformedURLException me) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Google compute metadataUrl value is invalid!: " + this.configuration.getMetadataUrl(), (Throwable)me);
                }
            }
            catch (FileNotFoundException fnfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No metadata found at: " + this.configuration.getMetadataUrl() + "?recursive=true", (Throwable)fnfe);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) break block23;
                LOG.debug("Error connecting to" + this.configuration.getMetadataUrl() + "?recursive=true reading instance metadata", (Throwable)ioe);
            }
        }
        return Optional.ofNullable(instanceMetadata);
    }
}

