/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp;

import com.google.cloud.ServiceOptions;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;

@ConfigurationProperties(value="gcp")
@BootstrapContextCompatible
public class GoogleCloudConfiguration {
    public static final String NO_PROJECT_ID_MESSAGE = "No Google Cloud Project ID found. See ServiceOptions.getDefaultProjectId() for description on how to configure the service ID";
    public static final String PREFIX = "gcp";
    private String projectId;

    @NonNull
    public String getProjectId() {
        if (this.projectId == null) {
            this.projectId = ServiceOptions.getDefaultProjectId();
            if (this.projectId == null) {
                throw new ConfigurationException(NO_PROJECT_ID_MESSAGE);
            }
        }
        return this.projectId;
    }

    public void setProjectId(@Nullable String projectId) {
        this.projectId = projectId;
    }

    public boolean hasProjectId() {
        try {
            this.getProjectId();
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }
}

