/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.credentials;

import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.gcp.credentials.GoogleCredentialsConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Requires(classes={GoogleCredentials.class})
@BootstrapContextCompatible
public class GoogleCredentialsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCredentialsFactory.class);
    private final GoogleCredentialsConfiguration configuration;
    private final HttpTransportFactory httpTransportFactory;

    @Deprecated
    public GoogleCredentialsFactory(@NonNull GoogleCredentialsConfiguration configuration) {
        this(configuration, null);
    }

    @Inject
    public GoogleCredentialsFactory(@NonNull GoogleCredentialsConfiguration configuration, @Nullable HttpTransportFactory httpTransportFactory) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.configuration = configuration;
        this.httpTransportFactory = httpTransportFactory != null ? httpTransportFactory : NetHttpTransport::new;
    }

    @Requirements(value={@Requires(classes={GoogleCredentials.class}), @Requires(property="gcp.credentials.enabled", value="true", defaultValue="true")})
    @Primary
    @Singleton
    protected GoogleCredentials defaultGoogleCredentials() throws IOException {
        GoogleCredentials credentials;
        List scopes = this.configuration.getScopes().stream().map(URI::toString).collect(Collectors.toList());
        if (this.configuration.getLocation().isPresent() && this.configuration.getEncodedKey().isPresent()) {
            throw new ConfigurationException("Please specify only one of gcp.credentials.location or gcp.credentials.encodedKey");
        }
        if (this.configuration.getLocation().isPresent()) {
            LOG.info("Google Credentials from gcp.credentials.location = " + this.configuration.getLocation());
            FileInputStream fis = new FileInputStream(this.configuration.getLocation().get());
            credentials = GoogleCredentials.fromStream((InputStream)fis, (HttpTransportFactory)this.httpTransportFactory);
            fis.close();
        } else if (this.configuration.getEncodedKey().isPresent()) {
            LOG.info("Google Credentials from gcp.credentials.encodedKey");
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] bytes = decoder.decode(this.configuration.getEncodedKey().get());
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            credentials = GoogleCredentials.fromStream((InputStream)is, (HttpTransportFactory)this.httpTransportFactory);
            is.close();
        } else {
            LOG.info("Google Credentials from Application Default Credentials");
            credentials = GoogleCredentials.getApplicationDefault((HttpTransportFactory)this.httpTransportFactory);
        }
        return credentials.createScoped(scopes);
    }
}

