/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.web.router.AnnotatedMethodRouteBuilder;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.UriRoute;
import jakarta.inject.Singleton;

@Singleton
@Internal
@Replaces(value=AnnotatedMethodRouteBuilder.class)
class GoogleMethodRouteBuilder
extends AnnotatedMethodRouteBuilder {
    private final ServerContextPathProvider contextPathProvider;

    public GoogleMethodRouteBuilder(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService<?> conversionService, ServerContextPathProvider contextPathProvider) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
        this.contextPathProvider = contextPathProvider;
    }

    protected UriRoute buildBeanRoute(String httpMethodName, HttpMethod httpMethod, String uri, BeanDefinition<?> beanDefinition, ExecutableMethod<?, ?> method) {
        String cp = this.contextPathProvider.getContextPath();
        if (cp != null) {
            uri = StringUtils.prependUri((String)cp, (String)uri);
        }
        return super.buildBeanRoute(httpMethodName, httpMethod, uri, beanDefinition, method);
    }
}

