/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Internal
class GoogleMultiValueMap
implements ConvertibleMultiValues<String> {
    private final Map<String, List<String>> map;

    GoogleMultiValueMap(Map<String, List<String>> map) {
        this.map = Objects.requireNonNull(map, "Passed map cannot be null");
    }

    public List<String> getAll(CharSequence name) {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        return this.map.getOrDefault(name.toString(), Collections.emptyList());
    }

    @Nullable
    public String get(CharSequence name) {
        Iterator<String> i;
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        List<String> values = this.map.get(name.toString());
        if (values != null && (i = values.iterator()).hasNext()) {
            return i.next();
        }
        return null;
    }

    public Set<String> names() {
        return this.map.keySet();
    }

    public Collection<List<String>> values() {
        return this.map.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String v = this.get(name);
        if (v != null) {
            return ConversionService.SHARED.convert((Object)v, conversionContext);
        }
        return Optional.empty();
    }
}

