/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpResponse;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.gcp.function.http.GoogleMultiValueMap;
import io.micronaut.gcp.function.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;

@Internal
final class GoogleFunctionHttpResponse<B>
implements ServletHttpResponse<HttpResponse, B> {
    private final HttpResponseWrapper response;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private B body;
    private int status = HttpStatus.OK.getCode();
    private String reason = HttpStatus.OK.getReason();

    GoogleFunctionHttpResponse(HttpResponse response, MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        this.response = new HttpResponseWrapper(response);
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.conversionService = conversionService;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public BufferedWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (cookie instanceof NettyCookie) {
            NettyCookie nettyCookie = (NettyCookie)cookie;
            String encoded = ServerCookieEncoder.STRICT.encode(nettyCookie.getNettyCookie());
            this.header("Set-Cookie", encoded);
        }
        return this;
    }

    public MutableHttpHeaders getHeaders() {
        return new GoogleFunctionHeaders(this.conversionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            GoogleFunctionHttpResponse googleFunctionHttpResponse = this;
            synchronized (googleFunctionHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        this.body = body;
        return this;
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        this.status = status;
        this.reason = message == null ? HttpStatus.getDefaultReason((int)status) : message.toString();
        this.response.setStatusCode(status, this.reason);
        return this;
    }

    public int code() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public HttpResponse getNativeResponse() {
        return this.response;
    }

    private final class GoogleFunctionHeaders
    extends GoogleMultiValueMap
    implements MutableHttpHeaders {
        GoogleFunctionHeaders(ConversionService conversionService) {
            super(GoogleFunctionHttpResponse.this.response.getHeaders());
            this.setConversionService(conversionService);
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            ArgumentUtils.requireNonNull((String)"header", (Object)header);
            if (value != null) {
                GoogleFunctionHttpResponse.this.response.appendHeader(header.toString(), value.toString());
            } else {
                GoogleFunctionHttpResponse.this.response.getHeaders().remove(header.toString());
            }
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            ArgumentUtils.requireNonNull((String)"header", (Object)header);
            GoogleFunctionHttpResponse.this.response.getHeaders().remove(header.toString());
            return this;
        }

        @Override
        public void setConversionService(ConversionService conversionService) {
            super.setConversionService(conversionService);
        }
    }
}

