/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpResponse;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.gcp.function.http.GoogleFunctionHttpRequest;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import java.util.Optional;

@Internal
final class GoogleResponseBinder
implements TypedRequestArgumentBinder<HttpResponse> {
    static final Argument<HttpResponse> TYPE = Argument.of(HttpResponse.class);

    GoogleResponseBinder() {
    }

    public Argument<HttpResponse> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<HttpResponse> bind(ArgumentConversionContext<HttpResponse> context, HttpRequest<?> source) {
        if (source instanceof GoogleFunctionHttpRequest) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = (GoogleFunctionHttpRequest)source;
            return () -> Optional.of(googleFunctionHttpRequest.getGoogleResponse().getNativeResponse());
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

