/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpResponse;
import io.micronaut.http.HttpStatus;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class HttpResponseWrapper
implements HttpResponse {
    private final HttpResponse response;
    private HttpStatus httpStatus = HttpStatus.OK;
    private boolean open = true;

    HttpResponseWrapper(HttpResponse response) {
        this.response = response;
    }

    public void setStatusCode(int code) {
        if (this.open) {
            this.httpStatus = HttpStatus.valueOf((int)code);
            this.response.setStatusCode(code);
        }
    }

    public void setStatusCode(int code, String message) {
        if (this.open) {
            this.httpStatus = HttpStatus.valueOf((int)code);
            this.response.setStatusCode(code, message);
        }
    }

    public HttpStatus getStatus() {
        return this.httpStatus;
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public Optional<String> getContentType() {
        return this.response.getContentType();
    }

    public void appendHeader(String header, String value) {
        this.response.appendHeader(header, value);
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.getHeaders();
    }

    public OutputStream getOutputStream() throws IOException {
        this.open = false;
        return this.response.getOutputStream();
    }

    public BufferedWriter getWriter() throws IOException {
        this.open = false;
        return this.response.getWriter();
    }
}

