/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.http.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.gcp.http.client.GoogleAuthServiceConfig;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.annotation.PreDestroy;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requirements(value={@Requires(env={"gcp"}), @Requires(property="gcp.http.client.auth.patterns")})
@Filter(patterns={"${gcp.http.client.auth.patterns:/**}"})
public class GoogleAuthFilter
implements HttpClientFilter,
AutoCloseable {
    private static final String METADATA_FLAVOR = "Metadata-Flavor";
    private static final String GOOGLE = "Google";
    private static final String IDENTITY_TOKEN_URI = "/computeMetadata/v1/instance/service-accounts/default/identity?audience=";
    private final HttpClient authClient;
    private final BeanContext beanContext;

    public GoogleAuthFilter(BeanContext beanContext) {
        try {
            this.authClient = HttpClient.create((URL)new URL("http://metadata"));
        }
        catch (MalformedURLException e) {
            throw new HttpClientException("Cannot create Google Auth Client: " + e.getMessage(), (Throwable)e);
        }
        this.beanContext = beanContext;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Flux token = Mono.fromCallable(() -> this.encodeIdentityTokenURI(request)).flatMapMany(authURI -> this.authClient.retrieve((HttpRequest)HttpRequest.GET((String)authURI).header((CharSequence)METADATA_FLAVOR, (CharSequence)GOOGLE)));
        return token.flatMap(t -> chain.proceed(request.bearerAuth((CharSequence)t)));
    }

    @Override
    @PreDestroy
    public void close() {
        this.authClient.close();
    }

    private String encodeIdentityTokenURI(MutableHttpRequest<?> request) throws UnsupportedEncodingException {
        return IDENTITY_TOKEN_URI + URLEncoder.encode(this.getAudience(request), "UTF-8");
    }

    private String getAudience(MutableHttpRequest<?> request) {
        return request.getAttribute((CharSequence)"micronaut.http.serviceId").map(Object::toString).flatMap(serviceId -> this.beanContext.findBean(GoogleAuthServiceConfig.class, Qualifiers.byName((String)serviceId))).map(GoogleAuthServiceConfig::getAudience).orElseGet(() -> this.getAudienceFromRequest(request));
    }

    private String getAudienceFromRequest(MutableHttpRequest<?> request) {
        URI fullURI = request.getUri();
        return fullURI.getScheme() + "://" + fullURI.getHost();
    }
}

