/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.logging;

import ch.qos.logback.core.PropertyDefinerBase;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;

public class GoogleCloudPropertyDefiner
extends PropertyDefinerBase {
    private static final int DEFAULT_READ_TIMEOUT = 500;
    private static final int DEFAULT_CONNECT_TIMEOUT = 500;
    private static final String GOOGLE_COMPUTE_METADATA = "http://metadata.google.internal";

    public String getPropertyValue() {
        Object[] fromEnvironment = StringUtils.tokenizeToStringArray((String)Optional.ofNullable(System.getenv("MICRONAUT_ENVIRONMENTS")).orElse(""), (String)",");
        Object[] fromProperties = StringUtils.tokenizeToStringArray((String)Optional.ofNullable(System.getProperty("micronaut.environments")).orElse(""), (String)",");
        String[] combinedEnvironments = (String[])ArrayUtils.concat((Object[])fromEnvironment, (Object[])fromProperties);
        boolean isGcp = false;
        isGcp = combinedEnvironments.length > 0 ? Arrays.stream(combinedEnvironments).anyMatch(s -> s.equals("gcp")) : this.isGoogleCompute().booleanValue();
        return isGcp ? "CONSOLE_JSON" : "STDOUT";
    }

    private Boolean isGoogleCompute() {
        try {
            String inputLine;
            HttpURLConnection con = this.createConnection(GOOGLE_COMPUTE_METADATA);
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            if (con.getHeaderField("Metadata-Flavor") != null && con.getHeaderField("Metadata-Flavor").equalsIgnoreCase("Google")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private HttpURLConnection createConnection(String spec) throws IOException {
        URL url = new URL(spec);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setReadTimeout(500);
        con.setConnectTimeout(500);
        return con;
    }
}

