/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.JsonFormatter;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import com.google.cloud.ServiceOptions;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.gcp.logging.StackdriverTraceConstants;
import io.micronaut.json.JsonMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class StackdriverJsonLayout
extends JsonLayout {
    private static final Map<Level, String> LOGBACK_TO_GCP_SEVERITY_MAP = Map.of(Level.ALL, "DEBUG", Level.TRACE, "DEBUG", Level.DEBUG, "DEBUG", Level.INFO, "INFO", Level.WARN, "WARNING", Level.ERROR, "ERROR");
    private static final String DEFAULT_LOG_SEVERITY = "DEBUG";
    private static final Set<String> FILTERED_MDC_FIELDS = new HashSet<String>(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-Span-Export"));
    private static final Supplier<JsonFormatter> JSON_FORMATTER_SUPPLIER = SupplierUtil.memoized(() -> arg_0 -> ((JsonMapper)JsonMapper.createDefault()).writeValueAsString(arg_0));
    private String projectId;
    private boolean includeTraceId;
    private boolean includeSpanId;
    private boolean includeExceptionInMessage;
    private Map<String, Object> customJson;

    public StackdriverJsonLayout() {
        this.appendLineSeparator = true;
        this.includeExceptionInMessage = true;
        this.includeException = false;
        this.includeTraceId = true;
        this.includeSpanId = true;
    }

    public JsonFormatter getJsonFormatter() {
        return JSON_FORMATTER_SUPPLIER.get();
    }

    public void start() {
        super.start();
        if (StringUtils.isEmpty((CharSequence)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED")) {
            this.projectId = ServiceOptions.getDefaultProjectId();
        }
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.includeMDC) {
            event.getMDCPropertyMap().forEach((key, value) -> {
                if (!FILTERED_MDC_FIELDS.contains(key)) {
                    map.put((String)key, value);
                }
            });
        }
        if (this.includeTimestamp) {
            map.put("timestampSeconds", TimeUnit.MILLISECONDS.toSeconds(event.getTimeStamp()));
            map.put("timestampNanos", TimeUnit.MILLISECONDS.toNanos(event.getTimeStamp() % 1000L));
        }
        this.add("severity", this.includeLevel, LOGBACK_TO_GCP_SEVERITY_MAP.getOrDefault(event.getLevel(), DEFAULT_LOG_SEVERITY), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        if (this.includeFormattedMessage) {
            String stackTrace;
            IThrowableProxy throwableProxy;
            Object message = event.getFormattedMessage();
            if (this.includeExceptionInMessage && (throwableProxy = event.getThrowableProxy()) != null && (stackTrace = this.getThrowableProxyConverter().convert((Object)event)) != null && !stackTrace.equals("")) {
                message = (String)message + "\n" + stackTrace;
            }
            map.put("message", message);
        }
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addTraceId(event, map);
        this.add("logging.googleapis.com/spanId", this.includeSpanId, (String)event.getMDCPropertyMap().get("X-B3-SpanId"), map);
        if (this.customJson != null && !this.customJson.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.customJson.entrySet()) {
                map.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        this.addCustomDataToJsonMap(map, event);
        return map;
    }

    protected String formatTraceId(String traceId) {
        return ("00000000000000000000000000000000" + traceId).substring(traceId.length());
    }

    private void addTraceId(ILoggingEvent event, Map<String, Object> map) {
        if (!this.includeTraceId) {
            return;
        }
        String traceId = (String)event.getMDCPropertyMap().get("X-B3-TraceId");
        if (!(StringUtils.isEmpty((CharSequence)traceId) || StringUtils.isEmpty((CharSequence)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED"))) {
            traceId = StackdriverTraceConstants.composeFullTraceName(this.projectId, this.formatTraceId(traceId));
        }
        this.add("logging.googleapis.com/trace", this.includeTraceId, traceId, map);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public boolean isIncludeTraceId() {
        return this.includeTraceId;
    }

    public void setIncludeTraceId(boolean includeTraceId) {
        this.includeTraceId = includeTraceId;
    }

    public boolean isIncludeSpanId() {
        return this.includeSpanId;
    }

    public void setIncludeSpanId(boolean includeSpanId) {
        this.includeSpanId = includeSpanId;
    }

    public boolean isIncludeExceptionInMessage() {
        return this.includeExceptionInMessage;
    }

    public void setIncludeExceptionInMessage(boolean includeExceptionInMessage) {
        this.includeExceptionInMessage = includeExceptionInMessage;
    }

    public Map<String, Object> getCustomJson() {
        return this.customJson;
    }

    public void setCustomJson(Map<String, Object> customJson) {
        this.customJson = customJson;
    }
}

