/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.gcp.pubsub.bind.PubSubAnnotatedArgumentBinder;
import io.micronaut.gcp.pubsub.bind.PubSubArgumentBinder;
import io.micronaut.gcp.pubsub.bind.PubSubConsumerState;
import io.micronaut.gcp.pubsub.bind.PubSubDefaultArgumentBinder;
import io.micronaut.gcp.pubsub.bind.PubSubTypeArgumentBinder;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Singleton
public class PubSubBinderRegistry
implements ArgumentBinderRegistry<PubSubConsumerState> {
    private final PubSubDefaultArgumentBinder defaultBinder;
    private final Map<Class<? extends Annotation>, ArgumentBinder<?, PubSubConsumerState>> byAnnotation = new HashMap();
    private final Map<Integer, ArgumentBinder<?, PubSubConsumerState>> byType = new HashMap();

    public PubSubBinderRegistry(PubSubDefaultArgumentBinder defaultBinder, PubSubArgumentBinder ... binders) {
        this.defaultBinder = defaultBinder;
        if (ArrayUtils.isNotEmpty((Object[])binders)) {
            for (PubSubArgumentBinder binder : binders) {
                if (binder instanceof PubSubAnnotatedArgumentBinder) {
                    PubSubAnnotatedArgumentBinder annotatedArgumentBinder = (PubSubAnnotatedArgumentBinder)binder;
                    this.byAnnotation.putIfAbsent(annotatedArgumentBinder.getAnnotationType(), binder);
                    continue;
                }
                if (!(binder instanceof PubSubTypeArgumentBinder)) continue;
                PubSubTypeArgumentBinder typeBinder = (PubSubTypeArgumentBinder)binder;
                this.byType.put(typeBinder.argumentType().typeHashCode(), typeBinder);
            }
        }
    }

    public <T> Optional<ArgumentBinder<T, PubSubConsumerState>> findArgumentBinder(Argument<T> argument, PubSubConsumerState source) {
        Optional opt = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (opt.isPresent()) {
            Class annotationType = (Class)opt.get();
            ArgumentBinder<?, PubSubConsumerState> binder = this.byAnnotation.get(annotationType);
            if (binder != null) {
                return Optional.of(binder);
            }
        } else {
            ArgumentBinder<?, PubSubConsumerState> binder = this.byType.get(argument.typeHashCode());
            if (binder != null) {
                return Optional.of(binder);
            }
        }
        return Optional.of(this.defaultBinder);
    }
}

