/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.bind;

import com.google.pubsub.v1.PubsubMessage;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.gcp.pubsub.bind.PubSubAnnotatedArgumentBinder;
import io.micronaut.gcp.pubsub.bind.PubSubConsumerState;
import io.micronaut.gcp.pubsub.exception.PubSubListenerException;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDes;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDesRegistry;
import io.micronaut.messaging.annotation.MessageBody;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class PubSubBodyBinder
implements PubSubAnnotatedArgumentBinder<MessageBody> {
    private final PubSubMessageSerDesRegistry serDesRegistry;

    public PubSubBodyBinder(PubSubMessageSerDesRegistry serDesRegistry) {
        this.serDesRegistry = serDesRegistry;
    }

    public Class<MessageBody> getAnnotationType() {
        return MessageBody.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, PubSubConsumerState state) {
        Argument bodyType = context.getArgument();
        Object result = null;
        if (bodyType.getType().equals(byte[].class)) {
            result = state.getPubsubMessage().getData().toByteArray();
        } else if (bodyType.getType().equals(PubsubMessage.class)) {
            result = state.getPubsubMessage();
        } else {
            if (StringUtils.isEmpty((CharSequence)state.getContentType()) && !state.getPubsubMessage().containsAttributes("Content-Type")) {
                throw new PubSubListenerException("Could not detect Content-Type header at message and no Content-Type specified on method.");
            }
            PubSubMessageSerDes serDes = this.serDesRegistry.find(state.getContentType()).orElseThrow(() -> new PubSubListenerException("Could not locate a valid SerDes implementation for type: " + state.getContentType()));
            result = serDes.deserialize(state.getPubsubMessage().getData().toByteArray(), bodyType);
        }
        byte[] finalResult = result;
        return () -> Optional.ofNullable(finalResult);
    }
}

