/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.support;

import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.pubsub.v1.ProjectTopicName;
import io.micronaut.core.type.Argument;
import java.util.Map;
import java.util.Optional;

public class PubSubPublisherState
implements AutoCloseable {
    private final TopicState topicState;
    private final Map<String, String> staticMessageAttributes;
    private final Argument<?> bodyArgument;
    private final PublisherInterface publisher;
    private final Optional<Argument> orderingArgument;

    public PubSubPublisherState(TopicState topicState, Map<String, String> staticMessageAttributes, Argument<?> bodyArgument, PublisherInterface publisher, Optional<Argument> orderingArgument) {
        this.topicState = topicState;
        this.staticMessageAttributes = staticMessageAttributes;
        this.bodyArgument = bodyArgument;
        this.publisher = publisher;
        this.orderingArgument = orderingArgument;
    }

    public PublisherInterface getPublisher() {
        return this.publisher;
    }

    public TopicState getTopicState() {
        return this.topicState;
    }

    public Map<String, String> getStaticMessageAttributes() {
        return this.staticMessageAttributes;
    }

    public Argument<?> getBodyArgument() {
        return this.bodyArgument;
    }

    public Optional<Argument> getOrderingArgument() {
        return this.orderingArgument;
    }

    @Override
    public void close() throws Exception {
        if (this.publisher instanceof Publisher) {
            Publisher defaultPublisher = (Publisher)this.publisher;
            defaultPublisher.shutdown();
        }
    }

    public static class TopicState {
        private final String contentType;
        private final ProjectTopicName projectTopicName;
        private final String configurationName;
        private final String endpoint;
        private final Boolean ordered;

        public TopicState(String contentType, ProjectTopicName projectTopicName, String configurationName, String endpoint, Boolean ordered) {
            this.contentType = contentType;
            this.projectTopicName = projectTopicName;
            this.configurationName = configurationName;
            this.endpoint = endpoint;
            this.ordered = ordered;
        }

        public String getContentType() {
            return this.contentType;
        }

        public ProjectTopicName getProjectTopicName() {
            return this.projectTopicName;
        }

        public String getConfigurationName() {
            return this.configurationName;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Boolean getOrdered() {
            return this.ordered;
        }
    }
}

