/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.support;

import com.google.pubsub.v1.ProjectSubscriptionName;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;

public final class PubSubSubscriptionUtils {
    private PubSubSubscriptionUtils() {
    }

    public static ProjectSubscriptionName toProjectSubscriptionName(@NonNull String subscription, @Nullable String projectId) {
        ProjectSubscriptionName projectSubscriptionName = null;
        if (ProjectSubscriptionName.isParsableFrom((String)subscription)) {
            projectSubscriptionName = ProjectSubscriptionName.parse((String)subscription);
        } else {
            if (projectId == null) {
                throw new IllegalArgumentException("The project ID can't be null when using canonical topic name.");
            }
            projectSubscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscription);
        }
        return projectSubscriptionName;
    }
}

