/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.bind;

import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PubSubAttributesConvertibleValues
implements ConvertibleValues<String> {
    private final Map<String, String> attributes;
    private final ConversionService conversionService;
    private final List<ConversionError> conversionErrors = new ArrayList<ConversionError>();

    public PubSubAttributesConvertibleValues(Map<String, String> attributes, ConversionService conversionService) {
        this.attributes = attributes;
        this.conversionService = conversionService;
    }

    public Set<String> names() {
        return this.attributes.keySet();
    }

    public Collection<String> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String value = this.attributes.get(name.toString());
        if (value != null) {
            Optional converted = this.conversionService.convert((Object)value, conversionContext);
            conversionContext.getLastError().ifPresent(this.conversionErrors::add);
            return converted;
        }
        return Optional.empty();
    }
}

