/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.serdes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDes;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

@Singleton
public class JsonPubSubMessageSerDes
implements PubSubMessageSerDes {
    private final ObjectMapper mapper;

    public JsonPubSubMessageSerDes(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object deserialize(byte[] data, Argument<?> type) {
        try {
            if (type.hasTypeVariables()) {
                JavaType javaType = this.constructJavaType(type);
                return this.mapper.readValue(data, javaType);
            }
            return this.mapper.readValue(data, type.getType());
        }
        catch (IOException e) {
            throw new SerializationException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    @Override
    public byte[] serialize(Object data) {
        try {
            return this.mapper.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error encoding object [" + data + "] to JSON: " + e.getMessage());
        }
    }

    @Override
    public String supportedType() {
        return "application/json";
    }

    private <T> JavaType constructJavaType(Argument<T> type) {
        Map typeVariables = type.getTypeVariables();
        TypeFactory typeFactory = this.mapper.getTypeFactory();
        JavaType[] objects = this.toJavaTypeArray(typeFactory, typeVariables);
        return typeFactory.constructParametricType(type.getType(), objects);
    }

    private JavaType[] toJavaTypeArray(TypeFactory typeFactory, Map<String, Argument<?>> typeVariables) {
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (Argument<?> argument : typeVariables.values()) {
            if (argument.hasTypeVariables()) {
                javaTypes.add(typeFactory.constructParametricType(argument.getType(), this.toJavaTypeArray(typeFactory, argument.getTypeVariables())));
                continue;
            }
            javaTypes.add(typeFactory.constructType((Type)argument.getType()));
        }
        return javaTypes.toArray(new JavaType[0]);
    }
}

