/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.support;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.pubsub.v1.TopicName;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.gcp.pubsub.configuration.PublisherConfigurationProperties;
import io.micronaut.gcp.pubsub.exception.PubSubClientException;
import io.micronaut.gcp.pubsub.support.PublisherFactory;
import io.micronaut.gcp.pubsub.support.PublisherFactoryConfig;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@Singleton
public class DefaultPublisherFactory
implements PublisherFactory {
    private final TransportChannelProvider transportChannelProvider;
    private final CredentialsProvider credentialsProvider;
    private final BeanContext beanContext;

    public DefaultPublisherFactory(@Named(value="pubsub") TransportChannelProvider transportChannelProvider, @Named(value="pubsub") CredentialsProvider credentialsProvider, BeanContext beanContext) {
        this.transportChannelProvider = transportChannelProvider;
        this.credentialsProvider = credentialsProvider;
        this.beanContext = beanContext;
    }

    public Publisher createPublisher(@NonNull PublisherFactoryConfig config) {
        try {
            Publisher.Builder publisherBuilder = Publisher.newBuilder((TopicName)config.getTopicState().getProjectTopicName());
            Optional publisherConfiguration = this.beanContext.findBean(PublisherConfigurationProperties.class, Qualifiers.byName((String)config.getTopicState().getConfigurationName()));
            String executor = publisherConfiguration.map(p -> p.getExecutor()).orElse(config.getDefaultExecutor());
            ExecutorService executorService = (ExecutorService)this.beanContext.getBean(ExecutorService.class, Qualifiers.byName((String)executor));
            publisherBuilder.setEnableMessageOrdering(config.getTopicState().getOrdered().booleanValue());
            if (!StringUtils.isEmpty((CharSequence)config.getTopicState().getEndpoint())) {
                publisherBuilder.setEndpoint(config.getTopicState().getEndpoint());
            }
            if (publisherConfiguration.isPresent()) {
                publisherBuilder.setRetrySettings(((PublisherConfigurationProperties)publisherConfiguration.get()).getRetrySettings().build());
                BatchingSettings batchSettings = ((PublisherConfigurationProperties)publisherConfiguration.get()).getBatchingSettings().build();
                publisherBuilder.setBatchingSettings(BatchingSettings.newBuilder().setDelayThreshold(batchSettings.getDelayThreshold()).setElementCountThreshold(batchSettings.getElementCountThreshold()).setIsEnabled(batchSettings.getIsEnabled()).setRequestByteThreshold(batchSettings.getRequestByteThreshold()).setFlowControlSettings(((PublisherConfigurationProperties)publisherConfiguration.get()).getFlowControlSettings().build()).build());
            }
            if (!(executorService instanceof ScheduledExecutorService)) {
                throw new IllegalStateException("Invalid Executor type provided, please make sure you have a ScheduledExecutorService configured for Publisher: " + config.getTopicState().getProjectTopicName().getTopic());
            }
            publisherBuilder.setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)((ScheduledExecutorService)executorService)));
            publisherBuilder.setChannelProvider(this.transportChannelProvider);
            publisherBuilder.setCredentialsProvider(this.credentialsProvider);
            return publisherBuilder.build();
        }
        catch (Exception ex) {
            throw new PubSubClientException("Failed to create subscriber", ex);
        }
    }
}

