/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.support;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.pubsub.v1.Publisher;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.gcp.GoogleCloudConfiguration;
import io.micronaut.gcp.UserAgentHeaderProvider;
import io.micronaut.gcp.pubsub.configuration.PubSubConfigurationProperties;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.threeten.bp.Duration;

@Factory
@Requires(classes={Publisher.class})
public class PubSubConfigurationFactory {
    private final PubSubConfigurationProperties pubSubConfigurationProperties;
    private final GoogleCloudConfiguration googleCloudConfiguration;

    public PubSubConfigurationFactory(PubSubConfigurationProperties pubSubConfigurationProperties, GoogleCloudConfiguration googleCloudConfiguration) {
        this.pubSubConfigurationProperties = pubSubConfigurationProperties;
        this.googleCloudConfiguration = googleCloudConfiguration;
    }

    @Singleton
    public ExecutorProvider publisherExecutorProvider() {
        return FixedExecutorProvider.create((ScheduledExecutorService)Executors.newScheduledThreadPool(1));
    }

    @Singleton
    @Named(value="pubsub")
    @Requires(missingProperty="pubsub.emulator.host")
    public TransportChannelProvider transportChannelProvider() {
        return InstantiatingGrpcChannelProvider.newBuilder().setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider("pubsub")).setKeepAliveTime(Duration.ofMinutes((long)this.pubSubConfigurationProperties.getKeepAliveIntervalMinutes())).build();
    }

    @Singleton
    @Named(value="pubsub")
    @Requires(property="pubsub.emulator.host")
    public TransportChannelProvider localChannelProvider(Environment environment) {
        String host = (String)environment.getProperty("pubsub.emulator.host", String.class).get();
        return FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forTarget((String)host).usePlaintext().build()));
    }

    @Singleton
    @Named(value="pubsub")
    @Requires(missingProperty="pubsub.emulator.host")
    public CredentialsProvider credentialsProvider(GoogleCredentials credentials) {
        return FixedCredentialsProvider.create((Credentials)credentials);
    }

    @Singleton
    @Named(value="pubsub")
    @Requires(property="pubsub.emulator.host")
    public CredentialsProvider noCredentialsProvider() {
        return NoCredentialsProvider.create();
    }
}

