/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.configuration;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import org.threeten.bp.Duration;

@EachProperty(value="gcp.pubsub.publisher")
public class PublisherConfigurationProperties {
    static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds((long)10L);
    static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis((long)10L);
    static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
    static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 1000L;
    static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis((long)1L);
    private static final Duration DEFAULT_INITIAL_RPC_TIMEOUT = Duration.ofSeconds((long)5L);
    private static final Duration DEFAULT_MAX_RPC_TIMEOUT = Duration.ofSeconds((long)600L);
    private static final Duration DEFAULT_TOTAL_TIMEOUT = Duration.ofSeconds((long)600L);
    @ConfigurationBuilder(prefixes={"set"}, configurationPrefix="retry")
    private RetrySettings.Builder retrySettings = RetrySettings.newBuilder().setTotalTimeout(DEFAULT_TOTAL_TIMEOUT).setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofSeconds((long)60L)).setInitialRpcTimeout(DEFAULT_INITIAL_RPC_TIMEOUT).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(DEFAULT_MAX_RPC_TIMEOUT);
    @ConfigurationBuilder(prefixes={"set"}, configurationPrefix="batching")
    private BatchingSettings.Builder batchingSettings = BatchingSettings.newBuilder().setDelayThreshold(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(Long.valueOf(1000L)).setElementCountThreshold(Long.valueOf(100L));
    @ConfigurationBuilder(prefixes={"set"}, configurationPrefix="flow-control")
    private FlowControlSettings.Builder flowControlSettings = FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore);
    private final String name;
    private String executor = "scheduled";

    public PublisherConfigurationProperties(@Parameter String name) {
        this.name = name;
    }

    public RetrySettings.Builder getRetrySettings() {
        return this.retrySettings;
    }

    public void setRetrySettings(RetrySettings.Builder retrySettings) {
        this.retrySettings = retrySettings;
    }

    public BatchingSettings.Builder getBatchingSettings() {
        return this.batchingSettings;
    }

    public void setBatchingSettings(BatchingSettings.Builder batchingSettings) {
        this.batchingSettings = batchingSettings;
    }

    public FlowControlSettings.Builder getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public void setFlowControlSettings(FlowControlSettings.Builder flowControlSettings) {
        this.flowControlSettings = flowControlSettings;
    }

    public String getName() {
        return this.name;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }
}

