/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.intercept;

import com.google.api.core.ApiFuture;
import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.StringUtils;
import io.micronaut.gcp.GoogleCloudConfiguration;
import io.micronaut.gcp.pubsub.annotation.OrderingKey;
import io.micronaut.gcp.pubsub.annotation.PubSubClient;
import io.micronaut.gcp.pubsub.annotation.Topic;
import io.micronaut.gcp.pubsub.configuration.PubSubConfigurationProperties;
import io.micronaut.gcp.pubsub.exception.PubSubClientException;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDes;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDesRegistry;
import io.micronaut.gcp.pubsub.support.PubSubPublisherState;
import io.micronaut.gcp.pubsub.support.PubSubTopicUtils;
import io.micronaut.gcp.pubsub.support.PublisherFactory;
import io.micronaut.gcp.pubsub.support.PublisherFactoryConfig;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.messaging.annotation.MessageHeader;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
public class PubSubClientIntroductionAdvice
implements MethodInterceptor<Object, Object>,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(PubSubClientIntroductionAdvice.class);
    private final ConcurrentHashMap<ExecutableMethod, PubSubPublisherState> publisherStateCache = new ConcurrentHashMap();
    private final PublisherFactory publisherFactory;
    private final PubSubMessageSerDesRegistry serDesRegistry;
    private final ConversionService conversionService;
    private final GoogleCloudConfiguration googleCloudConfiguration;
    private final PubSubConfigurationProperties pubSubConfigurationProperties;
    private final ExecutorService executorService;

    public PubSubClientIntroductionAdvice(PublisherFactory publisherFactory, PubSubMessageSerDesRegistry serDesRegistry, @Named(value="io") ExecutorService executorService, ConversionService conversionService, GoogleCloudConfiguration googleCloudConfiguration, PubSubConfigurationProperties pubSubConfigurationProperties) {
        this.publisherFactory = publisherFactory;
        this.executorService = executorService;
        this.serDesRegistry = serDesRegistry;
        this.conversionService = conversionService;
        this.googleCloudConfiguration = googleCloudConfiguration;
        this.pubSubConfigurationProperties = pubSubConfigurationProperties;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (context.hasAnnotation(Topic.class)) {
            String result;
            Argument[] arguments;
            ReturnType returnTypeInfo;
            PubSubPublisherState publisherState = this.publisherStateCache.computeIfAbsent(context.getExecutableMethod(), method -> {
                String projectId = method.stringValue(PubSubClient.class, "project").orElse(this.googleCloudConfiguration.getProjectId());
                Optional<Argument> orderingArgument = Arrays.stream(method.getArguments()).filter(argument -> argument.getAnnotationMetadata().hasAnnotation(OrderingKey.class)).findFirst();
                String topic = method.stringValue(Topic.class).orElse(context.getName());
                String endpoint = method.stringValue(Topic.class, "endpoint").orElse(this.pubSubConfigurationProperties.getTopicEndpoint());
                String configurationName = method.stringValue(Topic.class, "configuration").orElse("");
                String contentType = method.stringValue(Topic.class, "contentType").orElse("application/json");
                ProjectTopicName projectTopicName = PubSubTopicUtils.toProjectTopicName(topic, projectId);
                HashMap<String, String> staticMessageAttributes = new HashMap<String, String>();
                List headerAnnotations = context.getAnnotationValuesByType(MessageHeader.class);
                headerAnnotations.forEach(header -> {
                    String name = header.stringValue("name").orElse(null);
                    String value = header.stringValue().orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value)) {
                        staticMessageAttributes.put(name, value);
                    }
                });
                Argument<?> bodyArgument = this.findBodyArgument((ExecutableMethod<?, ?>)method).orElseThrow(() -> new PubSubClientException("No valid message body argument found for method: " + context.getExecutableMethod()));
                PubSubPublisherState.TopicState topicState = new PubSubPublisherState.TopicState(contentType, projectTopicName, configurationName, endpoint, orderingArgument.isPresent());
                this.logger.debug("Created a new publisher[{}] for topic: {}", (Object)context.getExecutableMethod().getName(), (Object)topic);
                PublisherInterface publisher = this.publisherFactory.createPublisher(new PublisherFactoryConfig(topicState, this.pubSubConfigurationProperties.getPublishingExecutor()));
                return new PubSubPublisherState(topicState, staticMessageAttributes, bodyArgument, publisher, orderingArgument);
            });
            HashMap<String, String> messageAttributes = new HashMap<String, String>(publisherState.getStaticMessageAttributes());
            String contentType = publisherState.getTopicState().getContentType();
            Argument<?> bodyArgument = publisherState.getBodyArgument();
            Map parameterValues = context.getParameterValueMap();
            ReturnType returnType = returnTypeInfo = context.getReturnType();
            Class javaReturnType = returnType.getType();
            for (Argument arg : arguments = context.getArguments()) {
                AnnotationValue headerAnn = arg.getAnnotation(MessageHeader.class);
                if (headerAnn == null) continue;
                Map.Entry<String, String> entry = this.getNameAndValue(arg, headerAnn, parameterValues);
                messageAttributes.put(entry.getKey(), entry.getValue());
            }
            PublisherInterface publisher = publisherState.getPublisher();
            Object body = parameterValues.get(bodyArgument.getName());
            PubsubMessage pubsubMessage = null;
            if (body.getClass() == PubsubMessage.class) {
                pubsubMessage = (PubsubMessage)body;
            } else {
                byte[] serialized = null;
                if (body.getClass() == byte[].class) {
                    serialized = (byte[])body;
                } else {
                    PubSubMessageSerDes serDes = this.serDesRegistry.find(contentType).orElseThrow(() -> new PubSubClientException("Could not locate a valid SerDes implementation for type: " + contentType));
                    serialized = serDes.serialize(body);
                }
                messageAttributes.put("Content-Type", contentType);
                PubsubMessage.Builder messageBuilder = PubsubMessage.newBuilder();
                messageBuilder.setData(ByteString.copyFrom((byte[])serialized)).putAllAttributes(messageAttributes);
                if (publisherState.getOrderingArgument().isPresent()) {
                    String orderingKey = (String)this.conversionService.convert(parameterValues.get(publisherState.getOrderingArgument().get().getName()), String.class).orElseThrow(() -> new PubSubClientException("Could not convert argument annotated with @OrderingKey to String type"));
                    messageBuilder.setOrderingKey(orderingKey);
                }
                pubsubMessage = messageBuilder.build();
            }
            PubsubMessage finalPubsubMessage = pubsubMessage;
            Mono reactiveResult = Mono.create(sink -> {
                ApiFuture future = publisher.publish(finalPubsubMessage);
                future.addListener(() -> {
                    try {
                        String result = (String)future.get();
                        sink.success((Object)result);
                    }
                    catch (Throwable e) {
                        sink.error(e);
                    }
                }, (Executor)this.executorService);
            });
            if (javaReturnType == Void.TYPE || javaReturnType == Void.class) {
                result = (String)reactiveResult.block();
                return null;
            }
            if (returnTypeInfo.isReactive()) {
                return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)reactiveResult, (Class)javaReturnType);
            }
            if (returnTypeInfo.isAsync()) {
                return reactiveResult.toFuture();
            }
            result = (String)reactiveResult.block();
            return this.conversionService.convert((Object)result, javaReturnType).orElseThrow(() -> new PubSubClientException("Could not convert publisher result to method return type: " + javaReturnType));
        }
        return context.proceed();
    }

    private Optional<Argument<?>> findBodyArgument(ExecutableMethod<?, ?> method) {
        return Optional.ofNullable(Arrays.stream(method.getArguments()).filter(argument -> argument.getAnnotationMetadata().hasAnnotation(MessageBody.class)).findFirst().orElseGet(() -> Arrays.stream(method.getArguments()).findFirst().orElse(null)));
    }

    private Map.Entry<String, String> getNameAndValue(Argument argument, AnnotationValue<?> annotationValue, Map<String, Object> parameterValues) {
        String argumentName = argument.getName();
        String name = annotationValue.stringValue("name").orElse(annotationValue.getValue(String.class).orElse(argumentName));
        String value = String.valueOf(parameterValues.get(argumentName));
        return new AbstractMap.SimpleEntry<String, String>(name, value);
    }

    @Override
    @PreDestroy
    public void close() throws Exception {
        for (PubSubPublisherState publisherState : this.publisherStateCache.values()) {
            publisherState.close();
        }
    }
}

