/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.intercept;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.gcp.GoogleCloudConfiguration;
import io.micronaut.gcp.pubsub.annotation.Subscription;
import io.micronaut.gcp.pubsub.bind.PubSubBinderRegistry;
import io.micronaut.gcp.pubsub.bind.SubscriberFactory;
import io.micronaut.gcp.pubsub.bind.SubscriberFactoryConfig;
import io.micronaut.gcp.pubsub.configuration.PubSubConfigurationProperties;
import io.micronaut.gcp.pubsub.exception.PubSubListenerException;
import io.micronaut.gcp.pubsub.exception.PubSubMessageReceiverExceptionHandler;
import io.micronaut.gcp.pubsub.intercept.AbstractPubSubConsumerMethodProcessor;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDesRegistry;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class PubSubConsumerAdvice
extends AbstractPubSubConsumerMethodProcessor<Subscription> {
    private final SubscriberFactory subscriberFactory;
    private final PubSubConfigurationProperties pubSubConfigurationProperties;

    public PubSubConsumerAdvice(BeanContext beanContext, ConversionService conversionService, PubSubMessageSerDesRegistry serDesRegistry, SubscriberFactory subscriberFactory, GoogleCloudConfiguration googleCloudConfiguration, PubSubConfigurationProperties pubSubConfigurationProperties, PubSubBinderRegistry binderRegistry, PubSubMessageReceiverExceptionHandler exceptionHandler) {
        super(Subscription.class, beanContext, conversionService, googleCloudConfiguration, binderRegistry, exceptionHandler);
        this.subscriberFactory = subscriberFactory;
        this.pubSubConfigurationProperties = pubSubConfigurationProperties;
    }

    @Override
    protected boolean doBeforeSubscriber(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
        if (this.pubSubConfigurationProperties.isNackOnShutdown() && this.isShutDownInitiated()) {
            ackReplyConsumer.nack();
            return false;
        }
        return true;
    }

    @Override
    protected void addSubscriber(ProjectSubscriptionName projectSubscriptionName, MessageReceiver receiver, String configuration) {
        try {
            this.subscriberFactory.createSubscriber(new SubscriberFactoryConfig(projectSubscriptionName, receiver, configuration, this.pubSubConfigurationProperties.getSubscribingExecutor()));
        }
        catch (Exception e) {
            throw new PubSubListenerException("Failed to create subscriber", e);
        }
    }
}

