/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.push;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.pubsub.v1.ProjectSubscriptionName;
import io.micronaut.core.annotation.Internal;
import io.micronaut.gcp.pubsub.exception.PubSubListenerException;
import io.micronaut.gcp.pubsub.push.PushRequest;
import io.micronaut.gcp.pubsub.push.PushSubscriberHandler;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import jakarta.inject.Singleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Internal
final class DefaultPushSubscriberHandler
implements PushSubscriberHandler {
    private final ConcurrentHashMap<ProjectSubscriptionName, MessageReceiver> receivers = new ConcurrentHashMap();

    DefaultPushSubscriberHandler() {
    }

    @Override
    public CompletableFuture<MutableHttpResponse<Object>> handleRequest(PushRequest pushRequest) {
        ProjectSubscriptionName subscription = ProjectSubscriptionName.parse((String)pushRequest.subscription());
        if (this.receivers.containsKey(subscription)) {
            MessageReceiver receiver = this.receivers.get(subscription);
            final CompletableFuture result = new CompletableFuture();
            receiver.receiveMessage(pushRequest.message().asPubsubMessage(), new AckReplyConsumer(){

                public void ack() {
                    result.complete(AckReply.ACK);
                }

                public void nack() {
                    result.complete(AckReply.NACK);
                }
            });
            return result.thenApply(reply -> switch (reply) {
                default -> throw new IncompatibleClassChangeError();
                case AckReply.ACK -> HttpResponse.ok((Object)"");
                case AckReply.NACK -> HttpResponse.unprocessableEntity().body((Object)"");
            });
        }
        return CompletableFuture.completedFuture(HttpResponse.notFound((Object)("No subscribers were found for subscription " + pushRequest.subscription())));
    }

    @Override
    public void addSubscriber(ProjectSubscriptionName projectSubscriptionName, MessageReceiver receiver) {
        this.receivers.compute(projectSubscriptionName, (k, v) -> {
            if (v != null) {
                throw new PubSubListenerException("Subscription %s is already registered for another method".formatted(projectSubscriptionName.toString()));
            }
            return receiver;
        });
    }

    private static enum AckReply {
        ACK,
        NACK;

    }
}

