/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.push;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.gcp.pubsub.push.PushControllerConfiguration;
import io.micronaut.gcp.pubsub.push.PushRequest;
import io.micronaut.gcp.pubsub.push.PushSubscriberHandler;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import jakarta.validation.Valid;
import java.util.concurrent.CompletableFuture;

@Requirements(value={@Requires(beans={PushControllerConfiguration.class}), @Requires(classes={Controller.class})})
@Controller(value="${gcp.pubsub.push.path:/push}")
public class PushController {
    private final PushSubscriberHandler handler;

    public PushController(PushSubscriberHandler handler) {
        this.handler = handler;
    }

    @Post(consumes={"application/json"})
    @SingleResult
    public CompletableFuture<MutableHttpResponse<Object>> handlePushRequest(@Valid @Body PushRequest message) {
        return this.handler.handleRequest(message);
    }
}

