/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.push;

import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.PubsubMessage;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.gcp.pubsub.validation.ValidPushMessage;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Map;

@Serdeable
public record PushRequest(@NotBlank String subscription, @Valid @NotNull PushMessage message) {

    @Serdeable
    @ValidPushMessage
    public record PushMessage(Map<String, String> attributes, String data, @NotBlank String messageId, @NotBlank String publishTime) {
        PubsubMessage asPubsubMessage() {
            Instant publishTimeInstant = ZonedDateTime.parse(this.publishTime()).toInstant();
            Timestamp publishTimeStamp = Timestamp.newBuilder().setSeconds(publishTimeInstant.getEpochSecond()).setNanos(publishTimeInstant.getNano()).build();
            PubsubMessage.Builder messageBuilder = PubsubMessage.newBuilder().setMessageId(this.messageId()).setPublishTime(publishTimeStamp);
            if (StringUtils.isNotEmpty((CharSequence)this.data)) {
                messageBuilder.setData(ByteString.copyFrom((byte[])Base64.getDecoder().decode(this.data())));
            }
            if (CollectionUtils.isNotEmpty(this.attributes)) {
                messageBuilder.putAllAttributes(this.attributes);
            }
            return messageBuilder.build();
        }
    }
}

