/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.serdes;

import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDes;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDesRegistry;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class DefaultPubSubMessageSerDesRegistry
implements PubSubMessageSerDesRegistry {
    private final Map<String, PubSubMessageSerDes> serDesRegistry;

    public DefaultPubSubMessageSerDesRegistry(PubSubMessageSerDes[] serDes) {
        this.serDesRegistry = Arrays.stream(serDes).collect(Collectors.toMap(PubSubMessageSerDes::supportedType, s -> s));
    }

    @Override
    public Optional<PubSubMessageSerDes> find(String contentType) {
        return Optional.ofNullable(this.serDesRegistry.get(contentType));
    }
}

