/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.configuration;

import com.google.api.gax.batching.FlowControlSettings;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import org.threeten.bp.Duration;

@EachProperty(value="gcp.pubsub.subscriber")
public class SubscriberConfigurationProperties {
    private static final Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = Duration.ofMinutes((long)60L);
    private final String name;
    private String executor = "scheduled";
    private Integer parallelPullCount = 1;
    private Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
    private Duration maxDurationPerAckExtension = Duration.ofMillis((long)0L);
    @ConfigurationBuilder(prefixes={"set"}, configurationPrefix="flow-control")
    private FlowControlSettings.Builder flowControlSettings = FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(1000L)).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L));

    public SubscriberConfigurationProperties(@Parameter String name) {
        this.name = name;
    }

    public Integer getParallelPullCount() {
        return this.parallelPullCount;
    }

    public void setParallelPullCount(Integer parallelPullCount) {
        this.parallelPullCount = parallelPullCount;
    }

    public Duration getMaxAckExtensionPeriod() {
        return this.maxAckExtensionPeriod;
    }

    public void setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
        this.maxAckExtensionPeriod = maxAckExtensionPeriod;
    }

    public Duration getMaxDurationPerAckExtension() {
        return this.maxDurationPerAckExtension;
    }

    public void setMaxDurationPerAckExtension(Duration maxDurationPerAckExtension) {
        this.maxDurationPerAckExtension = maxDurationPerAckExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public FlowControlSettings.Builder getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public void setFlowControlSettings(FlowControlSettings.Builder flowControlSettings) {
        this.flowControlSettings = flowControlSettings;
    }
}

