/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.configuration;

import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.util.StringUtils;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Duration;

@Singleton
public class ThreeTenConverterRegistrar
implements TypeConverterRegistrar {
    private static final Pattern DURATION_MATCHER = Pattern.compile("^(-?\\d+)([unsmhd])(s?)$");
    private static final int MILLIS = 3;

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(CharSequence.class, Duration.class, (object, targetType, context) -> {
            String value = object.toString().trim();
            if (value.startsWith("P")) {
                try {
                    return Optional.of(Duration.parse((CharSequence)value));
                }
                catch (DateTimeException e) {
                    context.reject((Object)value, (Exception)((Object)e));
                    return Optional.empty();
                }
            }
            Matcher matcher = DURATION_MATCHER.matcher(value);
            if (matcher.find()) {
                String amount = matcher.group(1);
                String g2 = matcher.group(2);
                char type = g2.charAt(0);
                try {
                    String seq;
                    switch (type) {
                        case 's': {
                            return Optional.of(Duration.ofSeconds((long)Long.valueOf(amount)));
                        }
                        case 'm': {
                            String ms = matcher.group(3);
                            if (StringUtils.hasText((CharSequence)ms)) {
                                return Optional.of(Duration.ofMillis((long)Long.valueOf(amount)));
                            }
                            return Optional.of(Duration.ofMinutes((long)Long.valueOf(amount)));
                        }
                        case 'h': {
                            return Optional.of(Duration.ofHours((long)Long.valueOf(amount)));
                        }
                        case 'd': {
                            return Optional.of(Duration.ofDays((long)Long.valueOf(amount)));
                        }
                    }
                    switch (seq = g2 + matcher.group(3)) {
                        case "ns": {
                            return Optional.of(Duration.ofNanos((long)Long.valueOf(amount)));
                        }
                    }
                    context.reject((Object)value, (Exception)((Object)new DateTimeException("Unparseable date format (" + value + "). Should either be a ISO-8601 duration or a round number followed by the unit type")));
                    return Optional.empty();
                }
                catch (NumberFormatException e) {
                    context.reject((Object)value, (Exception)e);
                }
            }
            return Optional.empty();
        });
    }
}

