/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.exception;

import io.micronaut.context.annotation.Primary;
import io.micronaut.gcp.pubsub.exception.PubSubMessageReceiverException;
import io.micronaut.gcp.pubsub.exception.PubSubMessageReceiverExceptionHandler;
import io.micronaut.gcp.pubsub.push.PubSubPushMessageReceiverException;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultPubSubMessageReceiverExceptionHandler
implements PubSubMessageReceiverExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(DefaultPubSubMessageReceiverExceptionHandler.class);

    public void handle(PubSubMessageReceiverException exception) {
        this.logger.error(String.format("Error processing message on bean %s listening for subscription: %s", exception.getListener().getClass().getName(), exception.getState().getSubscriptionName()), (Throwable)((Object)exception));
        if (exception.isAutoAcknowledge() || exception instanceof PubSubPushMessageReceiverException) {
            exception.getState().getAckReplyConsumer().nack();
        }
    }
}

