/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.pubsub.serdes;

import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.core.type.Argument;
import io.micronaut.gcp.pubsub.serdes.PubSubMessageSerDes;
import io.micronaut.json.JsonMapper;
import jakarta.inject.Singleton;
import java.io.IOException;

@Singleton
public class JsonPubSubMessageSerDes
implements PubSubMessageSerDes {
    private final JsonMapper jsonMapper;

    public JsonPubSubMessageSerDes(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public Object deserialize(byte[] data, Argument<?> type) {
        try {
            return this.jsonMapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new SerializationException("Error decoding JSON stream for type [" + type.getName() + "]: " + e.getMessage());
        }
    }

    @Override
    public byte[] serialize(Object data) {
        try {
            return this.jsonMapper.writeValueAsBytes(data);
        }
        catch (IOException e) {
            throw new SerializationException("Error encoding object [" + data + "] to JSON: " + e.getMessage());
        }
    }

    @Override
    public String supportedType() {
        return "application/json";
    }
}

