/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.tracing.zipkin;

import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.stackdriver.StackdriverTracePropagation;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.gcp.GoogleCloudConfiguration;
import io.micronaut.gcp.UserAgentHeaderProvider;
import io.micronaut.gcp.condition.RequiresGoogleProjectId;
import io.micronaut.tracing.brave.AsyncReporterConfiguration;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.stackdriver.StackdriverEncoder;
import zipkin2.reporter.stackdriver.StackdriverSender;

@Factory
@Requirements(value={@Requires(classes={StackdriverSender.class}), @Requires(property="gcp.tracing.enabled", value="true", defaultValue="true")})
public class StackdriverSenderFactory {
    public static final URI TRACE_SCOPE = URI.create("https://www.googleapis.com/auth/trace.append");
    public static final String TRACE_TARGET = "cloudtrace.googleapis.com";
    public static final String PROPERTY_ENABLED = "gcp.tracing.enabled";

    @Singleton
    @Bean(preDestroy="shutdownNow")
    @Named(value="stackdriverTraceSenderChannel")
    @NonNull
    protected ManagedChannel stackdriverTraceSenderChannel() {
        UserAgentHeaderProvider userAgentHeaderProvider = new UserAgentHeaderProvider("trace");
        return ManagedChannelBuilder.forTarget((String)TRACE_TARGET).userAgent(userAgentHeaderProvider.getUserAgent()).build();
    }

    @RequiresGoogleProjectId
    @Requires(classes={StackdriverSender.class})
    @Singleton
    @NonNull
    protected Sender stackdriverSender(@NonNull GoogleCloudConfiguration cloudConfiguration, @NonNull GoogleCredentials credentials, @NonNull @Named(value="stackdriverTraceSenderChannel") ManagedChannel channel) {
        GoogleCredentials traceCredentials = credentials.createScoped(Arrays.asList(TRACE_SCOPE.toString()));
        return StackdriverSender.newBuilder((Channel)channel).projectId(cloudConfiguration.getProjectId()).callOptions(CallOptions.DEFAULT.withCallCredentials(MoreCallCredentials.from((Credentials)traceCredentials))).build();
    }

    @Singleton
    @Requires(classes={StackdriverSender.class})
    @NonNull
    protected BeanCreatedEventListener<BraveTracerConfiguration> braveTracerConfigurationBeanCreatedEventListener() {
        return configuration -> {
            BraveTracerConfiguration configurationBean = (BraveTracerConfiguration)configuration.getBean();
            configurationBean.getTracingBuilder().propagationFactory(StackdriverTracePropagation.newFactory((Propagation.Factory)B3Propagation.FACTORY)).traceId128Bit(true).supportsJoin(false);
            return configurationBean;
        };
    }

    @Singleton
    @Requires(beans={StackdriverSender.class})
    protected Propagation.Factory stackdriverPropagation() {
        return StackdriverTracePropagation.newFactory((Propagation.Factory)B3Propagation.FACTORY);
    }

    @Singleton
    @Requirements(value={@Requires(classes={StackdriverSender.class}), @Requires(beans={AsyncReporterConfiguration.class})})
    public AsyncReporter<Span> stackdriverReporter(@NonNull AsyncReporterConfiguration configuration) {
        return configuration.getBuilder().build((BytesEncoder)StackdriverEncoder.V2);
    }
}

